package com.elitesland.fin.application.web.artype;

import com.elitesland.fin.application.facade.param.artype.ArTypeOuSaveParam;
import com.elitesland.fin.application.facade.param.artype.ArTypeParam;
import com.elitesland.fin.application.facade.vo.artype.ArTypeOuVO;
import com.elitesland.fin.application.facade.vo.artype.ArTypeVO;
import com.elitesland.fin.application.service.artype.ArTypeOuService;
import com.elitesland.fin.application.service.artype.ArTypeService;
import com.elitesland.fin.domain.param.artype.ArTypeOuPageParam;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.web.artype
 * @date 2022/4/11 11:50
 */
@RestController
@RequestMapping("/fin/arType")
@RequiredArgsConstructor
@Api(value = "应收单类型定义", tags = {"应收单类型定义"})
public class ArTypeController {

    public final ArTypeService arTypeService;
    public final ArTypeOuService arTypeOuService;


    @GetMapping("getDef")
    @ApiOperation("获取应收单类型默认")
    public ApiResult<ArTypeVO> getDef() {
        ApiResult<ArTypeVO> res = arTypeService.getDef();
        return res;
    }

    @GetMapping("getList")
    @ApiOperation("获取应收单类型列表")
    public ApiResult<List<ArTypeVO>> getList() {
        ApiResult<List<ArTypeVO>> res = arTypeService.getList();
        return res;
    }

    @PostMapping("save")
    @ApiOperation("新增应收单类型")
    public ApiResult<Long> save(@RequestBody ArTypeParam arTypeParam) {
        ApiResult<Long> save = arTypeService.save(arTypeParam);
        return save;
    }

    @PostMapping("update")
    @ApiOperation("修改应收单类型")
    public ApiResult<Long> update(@RequestBody ArTypeParam arTypeParam) {
        ApiResult<Long> save = arTypeService.update(arTypeParam);
        return save;
    }

    @GetMapping("get")
    @ApiOperation("获取应收单类型详情")
    public ApiResult<ArTypeVO> get(Long id) {
        ApiResult<ArTypeVO> res = arTypeService.get(id);
        return res;
    }

    @PostMapping("page")
    @ApiOperation("应收单类型分页列表")
    public ApiResult<PagingVO<ArTypeVO>> page(@RequestBody ArTypePageParam arTypePageParam) {
        ApiResult<PagingVO<ArTypeVO>> page = arTypeService.page(arTypePageParam);
        return page;
    }

    @PostMapping("enable")
    @ApiOperation("启用/状态批量修改")
    public ApiResult<Boolean> enable(@RequestBody List<Long> ids) {
        ApiResult<Boolean> res = arTypeService.updateEnableFlag(ids, true);
        return res;
    }

    @PostMapping("stop")
    @ApiOperation("停用/状态批量修改")
    public ApiResult<Boolean> stop(@RequestBody List<Long> ids) {
        ApiResult<Boolean> res = arTypeService.updateEnableFlag(ids, false);
        return res;
    }

    @PostMapping("ouPage")
    @ApiOperation("分页查询应收单类型对应的公司")
    public ApiResult<PagingVO<ArTypeOuVO>> page(@RequestBody ArTypeOuPageParam arTypeOuPageParam) {
        PagingVO<ArTypeOuVO> res = arTypeOuService.page(arTypeOuPageParam);
        return ApiResult.ok(res);
    }

    @PostMapping("updateDef/{id}")
    @ApiOperation("设置默认状态")
    public ApiResult<Long> updateDef(@PathVariable("id") Long id) {
        ApiResult<Long> res = arTypeService.updateDef(id);
        return res;
    }

    @DeleteMapping("del/{id}")
    @ApiOperation("删除应收单类型")
    public ApiResult<Long> del(@PathVariable("id") Long id) {
        ApiResult<Long> res = arTypeService.del(id);
        return res;
    }

    @ApiOperation("添加分配公司")
    @PostMapping("addOu")
    public ApiResult<Boolean> addOu(@RequestBody ArTypeOuSaveParam apTypeOuSaveParam) {
        ApiResult<Boolean> res = arTypeOuService.addOu(apTypeOuSaveParam);
        return res;
    }

    @PostMapping("cancelOu")
    @ApiOperation("取消分配公司")
    public ApiResult<Boolean> cancelOu(@RequestBody List<Long> ids) {
        ApiResult<Boolean> res = arTypeOuService.cancelOu(ids);
        return res;
    }
}
