package com.elitesland.fin.application.web.limitadjustorder;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.log.model.bo.OperationLogDTO;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.limitadjustorder.LimitAdjustOrderParam;
import com.elitesland.fin.application.facade.vo.limitadjustorder.LimitAdjustOrderVO;
import com.elitesland.fin.application.service.limitadjustorder.LimitAdjustOrderService;
import com.elitesland.fin.common.BusinessObjectConstant;
import com.elitesland.fin.common.BusinessObjectEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/25 10:08
 */
@RestController
@RequestMapping("/limitAdjust")
@RequiredArgsConstructor
@Api(value = "额度调整单", tags = {"额度调整单"})
@BusinessObject(businessType = BusinessObjectConstant.FIN_LIMIT_ADJUST)
public class LimitAdjustOrderController {

    private final LimitAdjustOrderService limitAdjustOrderService;
    private final OperationLogMqMessageService operationLogMqMessageService;
    @PostMapping("/page")
    @ApiOperation("分页查询额度调整单")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE
            ,operationDescription = "分页查询"
            ,logEnabled = false ,argsJsonEnabled = false,resultJsonEnabled = false)
    public ApiResult<PagingVO<LimitAdjustOrderVO>> page(@RequestBody LimitAdjustOrderParam limitAdjustOrderParam) {
        return ApiResult.ok(limitAdjustOrderService.page(limitAdjustOrderParam));
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation("新增/修改额度调整单")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SAVE
            ,operationDescription = "保存额度调整单"
            ,logEnabled = true ,argsJsonEnabled = true,resultJsonEnabled = true
            ,businessParamValueKey = "docNo",allowRepeatRequest = false
    )
    public ApiResult<Long> saveOrUpdate(@RequestBody LimitAdjustOrderParam limitAdjustOrderParam) {

        return ApiResult.ok(limitAdjustOrderService.saveOrUpdate(limitAdjustOrderParam));
    }

    @GetMapping("/submit/{id}")
    @ApiOperation("提交额度调整单")
    @BusinessObjectOperation(operationType = OperationTypeEnum.APPROVE_SUBMIT
            ,operationDescription = "提交额度调整单"
            ,logEnabled = true ,argsJsonEnabled = true,resultJsonEnabled = true,allowRepeatRequest = false)
    public ApiResult<Void> submit(@PathVariable("id") Long id) {
        limitAdjustOrderService.submit(id);
        return ApiResult.ok();
    }
}
