package com.elitesland.fin.domain.entity.payorder;

import cn.hutool.core.lang.Assert;
import com.elitesland.fin.common.UdcEnum;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.Data;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:13
 */
@Data
public class PayOrderDtl {

    private Long id;

    private Long masId;

    private String payType;

    private String payBank;

    private String payAccount;

    private String recBank;

    private String recAccount;

    private String sourceNo;

    private Integer sourceLine;

    private BigDecimal realPayAmt;

    private BigDecimal realPayCurAmt;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private String expensesType;

    private Long buId;

    private String buName;

    private String buCode;

    private String remark;

    private Long sourceId;

    private Long sourceLineId;

    public void checkMoney(BigDecimal exchangeRate) {
        //总金额=实际支付金额
        if (totalAmt.compareTo(realPayAmt) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行总金额与实际支付金额不等!");
        }
        //总金额本位币=总金额*汇率；
        if (totalCurAmt.compareTo(totalAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行总金额(本位币)与总金额*汇率不等!");
        }
        //实际支付金额本位币=实际支付金额*汇率；
        if (realPayCurAmt.compareTo(realPayAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行实际支付金额(本位币)与实际支付金额*汇率不等!");
        }
    }

    public void countMoney(BigDecimal exchangeRate) {
        this.realPayAmt = this.totalAmt;
        // 总金额本位币
        BigDecimal curAmt = totalAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
        // 实际支付金额本位币
        this.totalCurAmt = curAmt;
        BigDecimal realAmt = realPayAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
        this.realPayCurAmt = realAmt;

    }

    //必填项非空校验
    public void checkNotNull(Boolean flag, String createMode) {
        // 手工
        if (createMode.equals(UdcEnum.FIN_PAY_DOC_CLS_MANU.getValueCode())) {
            //新增时不校验付款单ID
            if (flag) {
                Assert.notNull(this.masId, "付款单ID不能为空");
            }
            Assert.notNull(this.payType, "付款方式不能为空");
            Assert.notNull(this.payBank, "我方银行账户不能为空");
            Assert.notNull(this.totalAmt, "总金额不能为空");
            Assert.notNull(this.recAccount, "收款银行账号不能为空");
        }
        // 采购订单
        if (createMode.equals(UdcEnum.FIN_PAY_DOC_CLS_PO.getValueCode())) {
            Assert.notNull(this.sourceNo, "来源单号不能为空");
            Assert.notNull(this.payType, "付款方式不能为空");
            Assert.notNull(this.totalAmt, "总金额不能为空");
        }


    }
}
