package com.elitesland.fin.infr.repo.arorder;


import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.domain.entity.arorder.QArOrderDtlDO;


import com.elitesland.fin.domain.param.arorder.ArOrderDtlPageParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.repo.aporder
 * @date 2022/3/16 10:41
 */
@Component
@RequiredArgsConstructor
public class ArOrderDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QArOrderDtlDO qArOrderDtlDO = QArOrderDtlDO.arOrderDtlDO;

    public PagingVO<ArOrderDtlDTO> page(ArOrderDtlPageParam arOrderDtlPageParam) {

        List<Predicate> predicates = new ArrayList<>();
        // 总单Id
        if (null != arOrderDtlPageParam.getMasId()) {
            predicates.add(qArOrderDtlDO.masId.eq(arOrderDtlPageParam.getMasId()));
        }
        predicates.add(qArOrderDtlDO.deleteFlag.eq(0));
        JPAQuery<ArOrderDtlDTO> query = select(ArOrderDtlDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        arOrderDtlPageParam.setPaging(query);
        arOrderDtlPageParam.fillOrders(query, qArOrderDtlDO);

        return PagingVO.<ArOrderDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qArOrderDtlDO.id,
                qArOrderDtlDO.sourceNo,
                qArOrderDtlDO.masId,
                qArOrderDtlDO.sourceLine,
                qArOrderDtlDO.itemId,
                qArOrderDtlDO.itemCode,
                qArOrderDtlDO.itemName,
                qArOrderDtlDO.itemType,
                qArOrderDtlDO.smallCateCode,
                qArOrderDtlDO.smallCateName,
                qArOrderDtlDO.uom,
                qArOrderDtlDO.uomName,
                qArOrderDtlDO.qty,
                qArOrderDtlDO.exclTaxPrice,
                qArOrderDtlDO.price,
                qArOrderDtlDO.taxRate,
                qArOrderDtlDO.totalAmt,
                qArOrderDtlDO.exclTaxAmt,
                qArOrderDtlDO.taxAmt,
                qArOrderDtlDO.totalCurAmt,
                qArOrderDtlDO.exclTaxCurAmt,
                qArOrderDtlDO.taxCurAmt,
                qArOrderDtlDO.remark,
                qArOrderDtlDO.buCode,
                qArOrderDtlDO.buId,
                qArOrderDtlDO.buName,
                qArOrderDtlDO.expensesType,
                qArOrderDtlDO.relateId
        )).from(qArOrderDtlDO);
    }


    public List<Long> findBySourceId(String sourceId) {
        List<Long> res = jpaQueryFactory.select(qArOrderDtlDO.masId)
                .from(qArOrderDtlDO)
                .where(qArOrderDtlDO.sourceNo.like("%" + sourceId + "%"))
                .where(qArOrderDtlDO.deleteFlag.eq(0))
                .fetch();

        return res;
    }

    public List<BigDecimal> countByMasId(Long id) {
        return jpaQueryFactory.select(qArOrderDtlDO.qty)
                .from(qArOrderDtlDO)
                .where(qArOrderDtlDO.masId.eq(id))
                .where(qArOrderDtlDO.deleteFlag.eq(0))
                .fetch();
    }

    public Long del(List<Long> ids) {
        long res = jpaQueryFactory.update(qArOrderDtlDO)
                .set(qArOrderDtlDO.deleteFlag, 1)
                .where(qArOrderDtlDO.masId.in(ids))
                .execute();
        return res;
    }

    public void delByMasId(List<Long> id) {
        jpaQueryFactory.delete(qArOrderDtlDO)
                .where(qArOrderDtlDO.masId.in(id))
                .execute();
    }
    @SysCodeProc
    public List<ArOrderDtlDTO> listByMisId(Long masId) {
        List<ArOrderDtlDTO> res = select(ArOrderDtlDTO.class)
                .where(qArOrderDtlDO.masId.eq(masId))
                .where(qArOrderDtlDO.deleteFlag.eq(0))
                .fetch();
        return res;
    }

}
