package com.elitesland.fin.repo.account;

import com.elitesland.fin.entity.account.AccountStorageDetailDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * @author sunxw
 * @description
 * @Date 2023/5/30
 */
@Repository
public interface AccountStorageDetailRepo extends JpaRepository<AccountStorageDetailDO,Long>, QuerydslPredicateExecutor<AccountStorageDetailDO> {

    @Modifying
    @Query(value = "update account_storage_detail set ori_msg = :oriMsg where storage_id = :storageId",nativeQuery = true)
    void updateOriMsg(@Param("storageId") Long storageId, @Param("oriMsg") String oriMsg);

    @Query(value = "select id from account_storage_detail where refund_order_id = :orderId",nativeQuery = true)
    Long selectIdByRefundId(@Param("orderId") String orderId);

}
