package com.elitesland.fin.rpc.workflow;

import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Objects;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.dubbo.workflow
 * @date 2022/5/16 09:50
 */
@Service
@RequiredArgsConstructor
public class WorkflowRpcServiceImpl implements WorkflowRpcService {

    private final WorkflowService workflowService;

    @Override
    public ProcessInfo startProcess(String procKey, String procInstName, String businessKey, HashMap<String, Object> variables) {
        WorkflowResult<ProcessInfo> processInfoWorkflowResult = workflowService.startProcess(StartProcessPayload.of(procKey, procInstName, businessKey, variables));
        if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
            throw new BusinessException("调用工作流异常，错误信息:" + processInfoWorkflowResult.getMsg());
        }
        return processInfoWorkflowResult.getData();
    }

}
