/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.fin.application.convert.writeoff.FinArRecVerApplyRecConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinArRecVerApplyRecSaveDTO;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyQuery;
import com.elitesland.fin.application.facade.param.writeoff.FinArRecVerApplyRecQuery;
import com.elitesland.fin.application.facade.vo.writeoff.FinArRecVerApplyRecVO;
import com.elitesland.fin.application.service.writeoff.FinArRecVerApplyRecService;
import com.elitesland.fin.domain.entity.writeoff.FinArRecVerApplyRecDO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinArRecVerApplyRecRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class FinArRecVerApplyRecServiceImpl
implements FinArRecVerApplyRecService {
    private final FinArRecVerApplyRecRepoProc finArRecVerApplyRecRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final RecOrderRepoProc recOrderRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(Long masId, List<FinArRecVerApplyRecSaveDTO> saveList) {
        Assert.notNull((Object)masId, (String)"\u4e3b\u8868ID\u4e0d\u80fd\u4e3aNull");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        List<String> recDocNoList = saveList.stream().map(FinArRecVerApplyRecSaveDTO::getRecDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<RecOrderDTO> recOrderDTOList = this.recOrderRepoProc.selectInOutCustByRecOrderNo(recDocNoList);
        HashMap recOrderDMap = CollectionUtil.isEmpty(recOrderDTOList) ? new HashMap() : recOrderDTOList.stream().collect(Collectors.toMap(RecOrderDTO::getRecOrderNo, t -> t, (t1, t2) -> t1));
        this.finArRecVerApplyRecRepoProc.save(saveList.stream().map(e -> {
            FinArRecVerApplyRecDO entity = FinArRecVerApplyRecConvert.INSTANCE.save2Do((FinArRecVerApplyRecSaveDTO)e);
            entity.setMasId(masId);
            RecOrderDTO recOrderDTO = (RecOrderDTO)recOrderDMap.get(entity.getRecDocNo());
            if (Objects.nonNull(recOrderDTO)) {
                String inOutCust = StringUtils.isBlank((CharSequence)entity.getInOutCust()) ? recOrderDTO.getInOutCust() : entity.getInOutCust();
                String relevanceOuCode = StringUtils.isBlank((CharSequence)entity.getRelevanceOuCode()) ? recOrderDTO.getRelevanceOuCode() : entity.getRelevanceOuCode();
                entity.setInOutCust(inOutCust);
                entity.setRelevanceOuCode(relevanceOuCode);
            }
            return entity;
        }).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Collection<Long> masIds) {
        this.finArRecVerApplyRecRepoProc.deleteByMasId(masIds);
    }

    @Override
    public List<FinArRecVerApplyRecVO> listByMasIds(Collection<Long> masIds) {
        List<FinArRecVerApplyRecVO> finArRecVerApplyRecVOList = this.finArRecVerApplyRecRepoProc.listByMasIds(masIds).stream().map(FinArRecVerApplyRecConvert.INSTANCE::entity2Vo).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(finArRecVerApplyRecVOList)) {
            return Collections.EMPTY_LIST;
        }
        List<String> relevanceOuCodeList = finArRecVerApplyRecVOList.stream().map(FinArRecVerApplyRecVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);
        finArRecVerApplyRecVOList.forEach(v -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return finArRecVerApplyRecVOList;
    }

    @Override
    public List<FinArRecVerApplyRecVO> listByQuery(FinArRecVerApplyRecQuery query) {
        return this.finArRecVerApplyRecRepoProc.listByQuery(query).stream().map(FinArRecVerApplyRecConvert.INSTANCE::entity2Vo).collect(Collectors.toList());
    }

    @Override
    public List<FinArRecVerApplyRecVO> listByOutRecDocNoOrDId(FinArRecVerApplyQuery query) {
        return this.finArRecVerApplyRecRepoProc.listByOutRecDocNoOrDId(query);
    }

    public FinArRecVerApplyRecServiceImpl(FinArRecVerApplyRecRepoProc finArRecVerApplyRecRepoProc, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, RecOrderRepoProc recOrderRepoProc) {
        this.finArRecVerApplyRecRepoProc = finArRecVerApplyRecRepoProc;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.recOrderRepoProc = recOrderRepoProc;
    }
}

