/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.arorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderDtlConvert;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementDtlPageParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementDtlVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.application.service.excel.entity.ArExportEntity;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtl;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDomainService;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDtlDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.dto.common.ArVerDTO;
import com.elitesland.fin.infr.factory.arorder.ArOrderFactory;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.repo.expense.ExpLedgerRepoProc;
import com.elitesland.fin.rpc.order.RmiOrderRpcService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.BeanUtils;
import com.elitesland.inv.dto.InvInterTran.InvInterTranFinReceiptSaveRpcParam;
import com.elitesland.inv.dto.invstk.InvIoFinReceiptSaveRpcParam;
import com.elitesland.inv.provider.InvInterTransactionDtlProvider;
import com.elitesland.inv.provider.InvStkProvider;
import com.elitesland.order.param.SalDoRespDTO;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.workflow.ProcessInfo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArOrderDomainServiceImpl
implements ArOrderDomainService {
    private static final Logger log = LoggerFactory.getLogger(ArOrderDomainServiceImpl.class);
    private final ArOrderRepo arOrderRepo;
    private final ArOrderRepoProc arOrderRepoProc;
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ArOrderDtlRepo arOrderDtlRepo;
    private final ArOrderFactory arOrderFactory;
    private final SaleInvRepo saleInvRepo;
    private final SeqNumProvider sysNumberRuleService;
    private final ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService;
    private final ReceiptPaymentAgreementDtlDomainService receiptPaymentAgreementDtlDomainService;
    private final FlexFieldUtilService flexFieldUtilService;
    private final RmiSaleRpcService rmiSaleRpcService;
    private final RmiOrderRpcService rmiOrderRpcService;
    private final ExpLedgerRepoProc expLedgerRepoProc;
    private ApOrderDomainService apOrderDomainService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final InvStkProvider invStkProvider;
    private final InvInterTransactionDtlProvider invInterTransactionDtlProvider;

    @Autowired
    @Lazy
    public void setApOrderDomainService(ApOrderDomainService apOrderDomainService) {
        this.apOrderDomainService = apOrderDomainService;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ArOrder arOrder) {
        if (Objects.equals(arOrder.getCreateMode(), UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode()) && StringUtils.isBlank((CharSequence)arOrder.getProtocolCode())) {
            this.handlePurSuppProtocolCode(arOrder);
            this.handleOtherAssemble(arOrder);
        }
        if (!Objects.equals(arOrder.getCreateMode(), UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            this.handleOtherProtocolCode(arOrder);
            this.handleOtherAssemble(arOrder);
        }
        arOrder.dtlAssign();
        if (arOrder.getVerAmt() == null) {
            arOrder.setDef();
        }
        arOrder.check();
        arOrder.checkDtlList();
        arOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        if (arOrder.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_SO.getValueCode())) {
            arOrder.setSoDef();
            arOrder.countBySo();
        }
        ArOrderDO apOrderRes = this.saveOrUpdate(arOrder);
        return apOrderRes.getId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handlePurSuppProtocolCode(ArOrder arOrder) {
        if (!StringUtils.isBlank((CharSequence)arOrder.getProtocolCode())) return;
        Map<String, CustBaseDTO> custMap = this.rmiSaleRpcService.findBaseCustMapByCodes(Collections.singletonList(arOrder.getCustCode()));
        if (!MapUtil.isNotEmpty(custMap) || !custMap.containsKey(arOrder.getCustCode())) throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u624b\u5de5\u65f6\u6536\u6b3e\u534f\u8bae\u4e3a\u7a7a\u65f6\u5ba2\u6237\u4e0d\u5b58\u5728");
        CustBaseDTO crmCustBaseDTO = custMap.get(arOrder.getCustCode());
        if (!Objects.nonNull(crmCustBaseDTO)) throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u624b\u5de5\u65f6\u6536\u6b3e\u534f\u8bae\u4e3a\u7a7a\u65f6\u5ba2\u6237\u4e0d\u5b58\u5728");
        if (StringUtils.isBlank((CharSequence)crmCustBaseDTO.getPaymentTerm())) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e94\u6536\u5355\u7684\u6765\u6e90\u5355\u53f7(" + arOrder.getSourceNo() + ")\u7684\u6536\u6b3e\u534f\u8bae\u4e3a\u7a7a");
        }
        arOrder.setProtocolCode(crmCustBaseDTO.getPaymentTerm());
    }

    private void handleOtherProtocolCode(ArOrder arOrder) {
        List docNos = arOrder.getDtlList().stream().map(ArOrderDtl::getSourceNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        arOrder.getDtlList().forEach(arOrderDtl -> {
            if (!StringUtils.isBlank((CharSequence)arOrderDtl.getProtocolCode())) return;
            Map<String, SalDoRespDTO> salDoRespDTOMap = this.rmiOrderRpcService.findSalDoMapByCodes(Collections.singletonList(arOrderDtl.getSourceNo()));
            if (!MapUtil.isNotEmpty(salDoRespDTOMap) || !salDoRespDTOMap.containsKey(arOrderDtl.getSourceNo())) throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6536\u6b3e\u534f\u8bae\u4e3a\u7a7a\u65f6\u6765\u6e90\u5355\u636e\u4e0d\u5b58\u5728");
            SalDoRespDTO salDoRespDTO = salDoRespDTOMap.get(arOrderDtl.getSourceNo());
            if (!Objects.nonNull(salDoRespDTO)) throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6536\u6b3e\u534f\u8bae\u4e3a\u7a7a\u65f6\u6765\u6e90\u5355\u636e\u4e0d\u5b58\u5728");
            if (StringUtils.isBlank((CharSequence)salDoRespDTO.getPaymentTerm())) {
                throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e94\u6536\u5355\u660e\u7ec6\u7684\u6765\u6e90\u5355\u53f7(" + arOrderDtl.getSourceNo() + ")\u7684\u6536\u6b3e\u534f\u8bae\u4e3a\u7a7a");
            }
            arOrderDtl.setProtocolCode(salDoRespDTO.getPaymentTerm());
        });
    }

    private void handleOtherAssemble(ArOrder arOrder) {
        CustBaseDTO crmCustBaseDTO;
        Map<String, CustBaseDTO> custMap;
        if ((StringUtils.isBlank((CharSequence)arOrder.getInOutCust()) || StringUtils.isBlank((CharSequence)arOrder.getRelevanceOuCode())) && MapUtil.isNotEmpty(custMap = this.rmiSaleRpcService.findBaseCustMapByCodes(Collections.singletonList(arOrder.getCustCode()))) && custMap.containsKey(arOrder.getCustCode()) && Objects.nonNull(crmCustBaseDTO = custMap.get(arOrder.getCustCode()))) {
            if (StringUtils.isBlank((CharSequence)arOrder.getInOutCust()) && StringUtils.isNotBlank((CharSequence)crmCustBaseDTO.getInOutCust())) {
                arOrder.setInOutCust(crmCustBaseDTO.getInOutCust());
            }
            if (Objects.equals(crmCustBaseDTO.getCustType2(), "C") && StringUtils.isBlank((CharSequence)arOrder.getRelevanceOuCode())) {
                arOrder.setRelevanceOuCode(crmCustBaseDTO.getCorBusinCode());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public ArOrderDO saveOrUpdate(ArOrder arOrder) {
        if (CharSequenceUtil.isBlank((CharSequence)arOrder.getArOrderNo())) {
            String apOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "YSD", null);
            arOrder.setArOrderNo(apOrderNo);
        }
        this.flexFieldUtilService.handFlexFieldValueFeference("AR_ORDER", (Object)arOrder);
        ArOrderDO apOrderDO = ArOrderConvert.INSTANCE.convert(arOrder);
        if (apOrderDO.getId() == null) {
            apOrderDO.setAuditDataVersion(0);
        }
        ArOrderDO apOrderRes = (ArOrderDO)this.arOrderRepo.save(apOrderDO);
        this.arOrderDtlRepoProc.delByMasId(Lists.newArrayList((Object[])new Long[]{apOrderRes.getId()}));
        List<ArOrderDtl> apOrderDtlList = arOrder.getDtlList();
        List<ArOrderDtlDO> apOrderDtlDOS = ArOrderDtlConvert.INSTANCE.convert(apOrderDtlList);
        List<String> protocolCodeList = apOrderDtlDOS.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getProtocolCode())).map(v -> v.getProtocolCode()).collect(Collectors.toList());
        List<ReceiptPaymentAgreementVO> receiptPaymentAgreementVOS = null;
        if (CollectionUtils.isNotEmpty(protocolCodeList)) {
            receiptPaymentAgreementVOS = this.receiptPaymentAgreementDomainService.selectReceiptByCodes(protocolCodeList);
        }
        Map<Object, Object> protocolCodeIdMap = new HashMap();
        Map<Object, Object> protocolDetailMap = new HashMap();
        if (CollectionUtils.isNotEmpty(receiptPaymentAgreementVOS)) {
            protocolCodeIdMap = receiptPaymentAgreementVOS.stream().collect(Collectors.toMap(v -> v.getProtocolCode(), v -> v.getId()));
            ReceiptPaymentAgreementDtlPageParam queryVO = new ReceiptPaymentAgreementDtlPageParam();
            queryVO.setMasIdList(receiptPaymentAgreementVOS.stream().map(v -> v.getId()).collect(Collectors.toList()));
            List<ReceiptPaymentAgreementDtlVO> receiptPaymentAgreementDtlVOS = this.receiptPaymentAgreementDtlDomainService.selectByParam(queryVO);
            protocolDetailMap = receiptPaymentAgreementDtlVOS.stream().collect(Collectors.groupingBy(v -> v.getMasId(), Collectors.toList()));
        }
        for (ArOrderDtlDO x : apOrderDtlDOS) {
            List receiptPaymentAgreementDtlVOList;
            x.setMasId(apOrderRes.getId());
            if (x.getId() == null) {
                x.setAuditDataVersion(0);
            }
            x.setVerAmt(BigDecimal.ZERO);
            x.setUnVerAmt(x.getTotalAmt());
            x.setApplyVerAmTing(BigDecimal.ZERO);
            ReceiptPaymentAgreementDtlVO receiptPaymentAgreementDtlVO = null;
            if (protocolCodeIdMap.containsKey(x.getProtocolCode()) && protocolDetailMap.containsKey(protocolCodeIdMap.get(x.getProtocolCode())) && CollectionUtil.isNotEmpty((Collection)(receiptPaymentAgreementDtlVOList = (List)protocolDetailMap.get(protocolCodeIdMap.get(x.getProtocolCode()))))) {
                receiptPaymentAgreementDtlVO = (ReceiptPaymentAgreementDtlVO)receiptPaymentAgreementDtlVOList.get(0);
            }
            x.setEs23(this.calculateStartCalDate(arOrder.getCreateMode(), arOrder.getBuDate(), receiptPaymentAgreementDtlVO));
            if (Objects.nonNull(x.getEs23())) {
                x.setEs24(this.calculateExpirePayDate(x.getEs23().toLocalDate(), receiptPaymentAgreementDtlVO));
            }
            this.arOrderDtlRepo.save(x);
        }
        return apOrderRes;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public Long commit(ArOrder arOrder, Boolean auto) {
        if (Objects.equals(arOrder.getCreateMode(), UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode()) && StringUtils.isBlank((CharSequence)arOrder.getProtocolCode())) {
            this.handlePurSuppProtocolCode(arOrder);
            this.handleOtherAssemble(arOrder);
        }
        if (!Objects.equals(arOrder.getCreateMode(), UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            this.handleOtherProtocolCode(arOrder);
            this.handleOtherAssemble(arOrder);
        }
        arOrder.dtlAssign();
        arOrder.check();
        arOrder.checkDtlList();
        if (Objects.equals(arOrder.getCreateMode(), UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            arOrder.checkAmt();
            arOrder.checkAmtSum();
        }
        if (arOrder.getVerAmt() == null) {
            arOrder.setDef();
        }
        if (auto.booleanValue()) {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            arOrder.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
        } else {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        }
        ArOrderDO arOrderDO = this.saveOrUpdate(arOrder);
        return arOrderDO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long newCommit(ArOrder arOrder, Boolean auto) {
        if (Objects.equals(arOrder.getCreateMode(), UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode()) && StringUtils.isBlank((CharSequence)arOrder.getProtocolCode())) {
            this.handlePurSuppProtocolCode(arOrder);
            this.handleOtherAssemble(arOrder);
        }
        if (!Objects.equals(arOrder.getCreateMode(), UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            this.handleOtherProtocolCode(arOrder);
            this.handleOtherAssemble(arOrder);
        }
        arOrder.dtlAssign();
        arOrder.check();
        arOrder.checkDtlList();
        if (Objects.equals(arOrder.getCreateMode(), UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            arOrder.checkAmt();
            arOrder.checkAmtSum();
        }
        if (arOrder.getVerAmt() == null) {
            arOrder.setDef();
        }
        if (auto.booleanValue()) {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            arOrder.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
        } else {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        }
        ArOrderDO arOrderDO = this.saveOrUpdate(arOrder);
        return arOrderDO.getId();
    }

    @Override
    public ArOrderDTO getArOrderAndDtl(Long id) {
        ArOrderDTO arOrderDTO = this.get(id);
        Map<Object, Object> ouMap = StringUtils.isBlank((CharSequence)arOrderDTO.getRelevanceOuCode()) ? new HashMap() : this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(Collections.singletonList(arOrderDTO.getRelevanceOuCode()));
        OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(arOrderDTO.getRelevanceOuCode());
        if (Objects.nonNull(ouRpcSimpleDTO)) {
            arOrderDTO.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
        }
        List<ArOrderDtlDTO> arOrderDtlDTOList = this.arOrderDtlRepoProc.listByMisId(id);
        List<Object> protocolCodeList = StringUtils.isBlank((CharSequence)arOrderDTO.getProtocolCode()) ? new ArrayList() : Collections.singletonList(arOrderDTO.getProtocolCode());
        List dtlProtocolCodeList = arOrderDtlDTOList.stream().map(ArOrderDtlDTO::getProtocolCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> protocolCodeAllList = Stream.of(dtlProtocolCodeList, protocolCodeList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, ReceiptPaymentAgreementVO> agreementMap = this.receiptPaymentAgreementDomainService.selectReceiptAgreementByCodes(protocolCodeAllList);
        this.handleArOrderDTO(arOrderDTO, agreementMap);
        this.handleArOrderDtlDTO(arOrderDtlDTOList, agreementMap);
        arOrderDTO.setArOrderDtlDTOList(arOrderDtlDTOList);
        return arOrderDTO;
    }

    private void handleArOrderDTO(ArOrderDTO arOrderDTO, Map<String, ReceiptPaymentAgreementVO> agreementMap) {
        ReceiptPaymentAgreementVO agreementVO;
        if (MapUtil.isNotEmpty(agreementMap) && agreementMap.containsKey(arOrderDTO.getProtocolCode()) && Objects.nonNull(agreementVO = agreementMap.get(arOrderDTO.getProtocolCode()))) {
            arOrderDTO.setProtocolName(agreementVO.getProtocolName());
        }
    }

    private void handleArOrderDtlDTO(List<ArOrderDtlDTO> arOrderDtlDTOS, Map<String, ReceiptPaymentAgreementVO> agreementMap) {
        if (CollectionUtil.isNotEmpty(arOrderDtlDTOS)) {
            arOrderDtlDTOS.forEach(arOrderDtlDTO -> {
                ReceiptPaymentAgreementVO agreementVO;
                if (MapUtil.isNotEmpty((Map)agreementMap) && agreementMap.containsKey(arOrderDtlDTO.getProtocolCode()) && Objects.nonNull(agreementVO = (ReceiptPaymentAgreementVO)agreementMap.get(arOrderDtlDTO.getProtocolCode()))) {
                    arOrderDtlDTO.setProtocolName(agreementVO.getProtocolName());
                }
            });
        }
    }

    @Override
    public Boolean queryByArTypeId(Long arTypeId) {
        return this.arOrderRepoProc.queryByArTypeId(arTypeId);
    }

    @Override
    public List<ArOrderDTO> getArOrderList(ArOrderParam arOrderParam) {
        List<ArOrderDTO> res = this.arOrderRepoProc.getArOrderList(arOrderParam);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Long id, BigDecimal amt) {
        ArVerDTO arVerDTO = this.arOrderRepoProc.queryVerAmtById(id);
        BigDecimal totalAmt = arVerDTO.getTotalAmt();
        if (arVerDTO.getVerAmt().add(amt).compareTo(totalAmt) > 0) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u6838\u9500\u91d1\u989d\u5927\u4e8e\u5e94\u6536\u5355\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u8f93\u5165");
        }
        arVerDTO.setAmtAndVerState(amt);
        long rows = this.arOrderRepoProc.updateVerAmt(arVerDTO);
        if (rows == 0L) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5e94\u4ed8\u5355\u66f4\u65b0\u5df2\u6838\u9500\u91d1\u989d\u5931\u8d25");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateWorkInfo(ProcessInfo processInfo, Long resId) {
        this.arOrderRepoProc.updateWorkInfo(processInfo, resId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSourceNo(String sourceNo, Long id) {
        this.arOrderRepoProc.updateSourceNo(sourceNo, id);
    }

    @Override
    public PagingVO<ArExportEntity> exportDefault(ArOrderPageParam param) {
        return this.arOrderRepoProc.exportDefault(param);
    }

    @Override
    public void restDocState(List<Long> ids) {
        List arOrderDOs = this.arOrderRepo.findAllById(ids);
        this.checkCancelDoc(arOrderDOs);
        arOrderDOs.forEach(arOrderDO -> {
            arOrderDO.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            arOrderDO.setProposedStatus(null);
            arOrderDO.setProcInstId(null);
            arOrderDO.setProcInstStatus(null);
        });
        this.arOrderRepo.saveAll(arOrderDOs);
    }

    void checkCancelDoc(List<ArOrderDO> arOrderDOs) {
        if (CollectionUtils.isEmpty(arOrderDOs)) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        List<ArOrderDtlDTO> arOrderDtlDTOS = this.arOrderDtlRepoProc.listByMasIds(arOrderDOs.stream().map(BaseModel::getId).collect(Collectors.toList()));
        Map<Long, List<ArOrderDtlDTO>> listMap = arOrderDtlDTOS.stream().collect(Collectors.groupingBy(ArOrderDtlDTO::getMasId));
        arOrderDOs.forEach(arOrderDO -> {
            BigDecimal verAmt;
            String perfix = "\u5355\u53f7\uff1a" + arOrderDO.getArOrderNo() + "-";
            if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(arOrderDO.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode().equals(arOrderDO.getProposedStatus())) {
                throw new BusinessException(perfix + "\u62df\u5b9a\u72b6\u6001\u5fc5\u987b\u4e3a\u8349\u7a3f\u6216\u62df\u5b9a\u5931\u8d25");
            }
            if (listMap.containsKey(arOrderDO.getId()) && CollUtil.isNotEmpty((Collection)((Collection)listMap.get(arOrderDO.getId()))) && CollUtil.isNotEmpty((Collection)((Collection)listMap.get(arOrderDO.getId()))) && BigDecimal.ZERO.compareTo(verAmt = ((List)listMap.get(arOrderDO.getId())).stream().map(ArOrderDtlDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
                throw new BusinessException(perfix + "\u5df2\u6838\u9500\u91d1\u989d\u5fc5\u987b\u4e3a0");
            }
            if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(arOrderDO.getOrderState())) {
                throw new BusinessException(perfix + "\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5ba1\u6838\u901a\u8fc7");
            }
            if (Boolean.TRUE.equals(arOrderDO.getRedState())) {
                throw new BusinessException(perfix + "\u5355\u636e\u5df2\u7ea2\u51b2");
            }
        });
    }

    @Override
    public ArOrderSaveParam redPunchCreate(Long id) {
        ArOrderDO arOrderDO = (ArOrderDO)this.arOrderRepo.findById(id).get();
        arOrderDO.setRedState(Boolean.TRUE);
        this.arOrderRepo.save(arOrderDO);
        ArOrderDO newArOrder = new ArOrderDO();
        BeanUtils.copyProperties((Object)arOrderDO, (Object)newArOrder, (String[])new String[0]);
        newArOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        newArOrder.setProcInstId(null);
        newArOrder.setProcInstStatus(null);
        newArOrder.setRedState(null);
        newArOrder.setRedSourceNo(arOrderDO.getArOrderNo());
        newArOrder.setRedSourceId(arOrderDO.getId());
        newArOrder.setTaxAmt(arOrderDO.getTaxAmt().negate());
        newArOrder.setTotalAmt(arOrderDO.getTotalAmt().negate());
        newArOrder.setExclTaxAmt(arOrderDO.getExclTaxAmt().negate());
        newArOrder.setTotalCurAmt(arOrderDO.getTotalCurAmt().negate());
        newArOrder.setTaxCurAmt(arOrderDO.getTaxCurAmt().negate());
        newArOrder.setExclTaxCurAmt(arOrderDO.getExclTaxCurAmt().negate());
        newArOrder.setId(null);
        newArOrder.setArOrderNo(null);
        newArOrder.setProposedStatus(null);
        newArOrder.setAuditUser(null);
        newArOrder.setApprovedTime(null);
        newArOrder.setAuditUserId(null);
        newArOrder.setRemark(null);
        List<ArOrderDtlDO> dtls = this.arOrderDtlRepo.findAllByMasId(id);
        List<ArOrderDtlDO> newDtls = dtls.stream().map(dtl -> {
            ArOrderDtlDO dtlDO = new ArOrderDtlDO();
            BeanUtils.copyProperties((Object)dtl, (Object)dtlDO, (String[])new String[0]);
            dtlDO.setId(null);
            dtlDO.setTaxAmt(dtl.getTaxAmt().negate());
            dtlDO.setTotalAmt(dtl.getTotalAmt().negate());
            dtlDO.setExclTaxAmt(dtl.getExclTaxAmt().negate());
            dtlDO.setTotalCurAmt(dtl.getTaxCurAmt().negate());
            dtlDO.setTaxCurAmt(dtl.getTotalCurAmt().negate());
            dtlDO.setExclTaxCurAmt(dtl.getExclTaxCurAmt().negate());
            dtlDO.setQty(dtlDO.getQty().negate());
            dtlDO.setExclTaxPrice(dtl.getExclTaxPrice());
            return dtlDO;
        }).collect(Collectors.toList());
        ArOrderSaveParam saveParam = ArOrderConvert.INSTANCE.convertParam(newArOrder);
        saveParam.setArOrderDtlParamList(ArOrderDtlConvert.INSTANCE.convertList(newDtls));
        return saveParam;
    }

    @Override
    public PagingVO<ArOrderDTO> page(ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderDTO> res = this.arOrderFactory.page(arOrderPageParam);
        return res;
    }

    @Override
    public PagingVO<ArOrderDTO> writeoffPage(ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderDTO> res = this.arOrderFactory.writeoffPage(arOrderPageParam);
        return res;
    }

    @Override
    public ArOrderDTO get(Long id) {
        ArOrderDTO arOrderDTO = this.arOrderRepoProc.get(id);
        List<ArOrderDtlDTO> arOrderDtlDTOS = this.arOrderDtlRepoProc.listByMisId(id);
        arOrderDTO.setArOrderDtlDTOList(arOrderDtlDTOS);
        return arOrderDTO;
    }

    @Override
    public List<ArOrderDTO> get(List<Long> ids) {
        List<ArOrderDTO> arOrderDTOS = this.arOrderRepoProc.get(ids);
        List<ArOrderDtlDTO> arOrderDtlDTOS = this.arOrderDtlRepoProc.listByMasIds(ids);
        Map<Long, List<ArOrderDtlDTO>> dtlDTOMap = arOrderDtlDTOS.stream().collect(Collectors.groupingBy(ArOrderDtlDTO::getMasId));
        for (ArOrderDTO arOrderDTO : arOrderDTOS) {
            if (!dtlDTOMap.containsKey(arOrderDTO.getId())) continue;
            arOrderDTO.setArOrderDtlDTOList(dtlDTOMap.get(arOrderDTO.getId()));
        }
        return arOrderDTOS;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long audit(List<Long> ids, String content, SysUserDTO user) {
        Long res = this.arOrderRepoProc.audit(ids, content, user);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByArOrderNoOrSourceNos(List<String> sourceNos, String sourceType) {
        List<Object> arOrderDOList = new ArrayList();
        if (Objects.equals("AP_AR_DELETE_EXP", sourceType)) {
            arOrderDOList = this.arOrderRepo.findAllByArOrderNoIn(sourceNos);
        } else if (Objects.equals("AP_AR_DELETE_OTHER", sourceType)) {
            arOrderDOList = this.arOrderRepo.findAllBySourceNoIn(sourceNos);
        } else if (Objects.equals("AP_AR_DELETE_INV_INTER_TRAN", sourceType)) {
            arOrderDOList = this.arOrderRepo.findAllByArOrderNoIn(sourceNos);
        }
        List<Long> ids = arOrderDOList.stream().map(BaseModel::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<ArOrderDTO> arOrderDTOS = this.arOrderRepoProc.queryByIds(ids);
        HashMap createSourceMap = new HashMap();
        arOrderDTOS.stream().forEach(x -> {
            if (!x.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5e94\u6536\u5355\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u5220\u9664");
            }
            if (Objects.nonNull(x.getSourceNo()) && Objects.isNull(x.getRedSourceNo())) {
                List sorceNos = createSourceMap.getOrDefault(x.getCreateMode(), new ArrayList());
                sorceNos.add(x.getSourceNo());
                createSourceMap.put(x.getCreateMode(), sorceNos);
            }
            if (Objects.nonNull(x.getRedSourceNo())) {
                this.arOrderRepoProc.setRedFlag(x.getRedSourceId(), false);
            }
        });
        for (Map.Entry entry : createSourceMap.entrySet()) {
            switch (Optional.ofNullable(UdcEnum.getByValueCode("FIN", "AR_DOC_CLS", (String)entry.getKey())).orElse(UdcEnum.DEFAUT)) {
                case FIN_AR_DOC_CLS_SINV: {
                    List<SaleInvDO> saleInvDOS = this.saleInvRepo.findByApplyNoIn((List)entry.getValue());
                    saleInvDOS.forEach(saleInvDO -> saleInvDO.setArFlag(Boolean.FALSE));
                    this.saleInvRepo.saveAll(saleInvDOS);
                    break;
                }
            }
        }
        List<Long> idList = arOrderDTOS.stream().map(ArOrderDTO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> expArOrderDtlSourceDocNos = null;
        List invIoIdList = null;
        if (CollectionUtils.isNotEmpty(idList)) {
            List<ArOrderDtlDO> arOrderDtlDOList = this.arOrderDtlRepo.findAllByMasIdIn(idList);
            expArOrderDtlSourceDocNos = arOrderDtlDOList.stream().map(ArOrderDtlDO::getSourceNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            invIoIdList = arOrderDtlDOList.stream().map(ArOrderDtlDO::getInvIoId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        Long res = this.arOrderRepoProc.del(ids);
        this.arOrderDtlRepoProc.delByMasId(ids);
        if (Objects.equals("AP_AR_DELETE_EXP", sourceType) && CollectionUtil.isNotEmpty(expArOrderDtlSourceDocNos)) {
            this.expLedgerRepoProc.updateFinFlagBySourceDocNos(expArOrderDtlSourceDocNos, "0");
        }
        if (Objects.equals("AP_AR_DELETE_OTHER", sourceType) && CollectionUtils.isNotEmpty(invIoIdList)) {
            InvIoFinReceiptSaveRpcParam invIoFinReceiptSaveRpcParam = new InvIoFinReceiptSaveRpcParam();
            invIoFinReceiptSaveRpcParam.setIdList(invIoIdList);
            invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_0);
            this.invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
        }
        if (Objects.equals("AP_AR_DELETE_INV_INTER_TRAN", sourceType) && CollectionUtils.isNotEmpty(invIoIdList)) {
            InvInterTranFinReceiptSaveRpcParam saveRpcParam = new InvInterTranFinReceiptSaveRpcParam();
            saveRpcParam.setIdList(invIoIdList);
            saveRpcParam.setFinFlag("0");
            saveRpcParam.setDeleteFlag(Boolean.valueOf(true));
            this.invInterTransactionDtlProvider.updateFinFlag(saveRpcParam);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        List<String> invInterTranArSourceNoList;
        List<String> otherpArSourceNoList;
        List<ArOrderDTO> arOrderDTOS = this.arOrderRepoProc.queryByIds(ids);
        HashMap createSourceMap = new HashMap();
        arOrderDTOS.stream().forEach(x -> {
            if (!x.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5e94\u6536\u5355\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u5220\u9664");
            }
            if (Objects.nonNull(x.getSourceNo()) && Objects.isNull(x.getRedSourceNo())) {
                List sorceNos = createSourceMap.getOrDefault(x.getCreateMode(), new ArrayList());
                sorceNos.add(x.getSourceNo());
                createSourceMap.put(x.getCreateMode(), sorceNos);
            }
            if (Objects.nonNull(x.getRedSourceNo())) {
                this.arOrderRepoProc.setRedFlag(x.getRedSourceId(), false);
            }
        });
        for (Map.Entry entry : createSourceMap.entrySet()) {
            switch (Optional.ofNullable(UdcEnum.getByValueCode("FIN", "AR_DOC_CLS", (String)entry.getKey())).orElse(UdcEnum.DEFAUT)) {
                case FIN_AR_DOC_CLS_SINV: {
                    List<SaleInvDO> saleInvDOS = this.saleInvRepo.findByApplyNoIn((List)entry.getValue());
                    saleInvDOS.forEach(saleInvDO -> saleInvDO.setArFlag(Boolean.FALSE));
                    this.saleInvRepo.saveAll(saleInvDOS);
                    break;
                }
            }
        }
        List expArOrderDTOList = arOrderDTOS.stream().filter(arOrderDTO -> Objects.equals("YSD02_SYS", arOrderDTO.getArTypeCode()) && Objects.equals(arOrderDTO.getCreateMode(), "EXP")).collect(Collectors.toList());
        List otherpArOrderDTOList = arOrderDTOS.stream().filter(arOrderDTO -> !Objects.equals("YSD02_SYS", arOrderDTO.getArTypeCode()) || !Objects.equals(arOrderDTO.getCreateMode(), "EXP")).collect(Collectors.toList());
        List invInterTranArOrderDTOList = arOrderDTOS.stream().filter(arOrderDTO -> Objects.equals("YSD02_SYS", arOrderDTO.getArTypeCode()) && Objects.equals(arOrderDTO.getCreateMode(), "INTER_IO")).collect(Collectors.toList());
        List<Long> expArIdList = expArOrderDTOList.stream().map(ArOrderDTO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> expArOrderDtlSourceDocNos = null;
        if (CollectionUtils.isNotEmpty(expArIdList)) {
            List<ArOrderDtlDO> expArOrderDtlDOList = this.arOrderDtlRepo.findAllByMasIdIn(expArIdList);
            expArOrderDtlSourceDocNos = expArOrderDtlDOList.stream().map(ArOrderDtlDO::getSourceNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        List<Long> otherpArIdList = otherpArOrderDTOList.stream().map(ArOrderDTO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List invIoIdList = null;
        if (CollectionUtils.isNotEmpty(otherpArIdList)) {
            List<ArOrderDtlDO> otherpArOrderDtlDOList = this.arOrderDtlRepo.findAllByMasIdIn(otherpArIdList);
            invIoIdList = otherpArOrderDtlDOList.stream().map(ArOrderDtlDO::getInvIoId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        List<Long> invInterTranArIdList = invInterTranArOrderDTOList.stream().map(ArOrderDTO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List invInterTranIoIdList = null;
        if (CollectionUtils.isNotEmpty(invInterTranArIdList)) {
            List<ArOrderDtlDO> invInterTranArOrderDtlDOList = this.arOrderDtlRepo.findAllByMasIdIn(invInterTranArIdList);
            invInterTranIoIdList = invInterTranArOrderDtlDOList.stream().map(ArOrderDtlDO::getInvIoId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }
        Long res = this.arOrderRepoProc.del(ids);
        this.arOrderDtlRepoProc.delByMasId(ids);
        List<String> expArSourceNoList = expArOrderDTOList.stream().map(ArOrderDTO::getSourceNo).filter(s -> StringUtils.isNotBlank((CharSequence)s)).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(expArSourceNoList)) {
            this.apOrderDomainService.delByApOrderNoOrSourceNos(expArSourceNoList, "AP_AR_DELETE_EXP");
        }
        if (CollectionUtils.isNotEmpty(otherpArSourceNoList = otherpArOrderDTOList.stream().map(ArOrderDTO::getSourceNo).filter(s -> StringUtils.isNotBlank((CharSequence)s)).distinct().collect(Collectors.toList()))) {
            this.apOrderDomainService.delByApOrderNoOrSourceNos(otherpArSourceNoList, "AP_AR_DELETE_OTHER");
        }
        if (CollectionUtils.isNotEmpty(invInterTranArSourceNoList = invInterTranArOrderDTOList.stream().map(ArOrderDTO::getSourceNo).filter(s -> StringUtils.isNotBlank((CharSequence)s)).distinct().collect(Collectors.toList()))) {
            this.apOrderDomainService.delByApOrderNoOrSourceNos(invInterTranArSourceNoList, "AP_AR_DELETE_INV_INTER_TRAN");
        }
        if (CollectionUtil.isNotEmpty(expArOrderDtlSourceDocNos)) {
            this.expLedgerRepoProc.updateFinFlagBySourceDocNos(expArOrderDtlSourceDocNos, "0");
        }
        if (CollectionUtils.isNotEmpty(invIoIdList)) {
            InvIoFinReceiptSaveRpcParam invIoFinReceiptSaveRpcParam = new InvIoFinReceiptSaveRpcParam();
            invIoFinReceiptSaveRpcParam.setIdList(invIoIdList);
            invIoFinReceiptSaveRpcParam.setFinInterFlag(FinConstant.FIN_INTER_FLAG_0);
            this.invStkProvider.updateFinInterFlag(invIoFinReceiptSaveRpcParam);
        }
        if (CollectionUtils.isNotEmpty(invInterTranIoIdList)) {
            InvInterTranFinReceiptSaveRpcParam saveRpcParam = new InvInterTranFinReceiptSaveRpcParam();
            saveRpcParam.setIdList(invInterTranIoIdList);
            saveRpcParam.setFinFlag("0");
            saveRpcParam.setDeleteFlag(Boolean.valueOf(true));
            this.invInterTransactionDtlProvider.updateFinFlag(saveRpcParam);
        }
        return res;
    }

    @Override
    public LocalDateTime calculateStartCalDate(String createMode, LocalDateTime buDate, ReceiptPaymentAgreementDtlVO receiptPaymentAgreementDtlVO) {
        log.info("\u8ba1\u7b97\u5e94\u6536\u5355\u4ed8\u6b3e\u8d77\u7b97\u65e5\u671f,\u6536\u6b3e\u534f\u8bae\u660e\u7ec6\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)receiptPaymentAgreementDtlVO));
        if (StringUtils.isBlank((CharSequence)createMode)) {
            log.error("\u8ba1\u7b97\u5e94\u6536\u5355\u4ed8\u6b3e\u8d77\u7b97\u65e5\u671f\uff0c\u5355\u636e\u6765\u6e90\u4e3a\u7a7a");
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u8ba1\u7b97\u5e94\u6536\u5355\u4ed8\u6b3e\u8d77\u7b97\u65e5\u671f\uff0c\u5355\u636e\u6765\u6e90\u4e3a\u7a7a");
        }
        LocalDate startCalDate = null;
        if (createMode.equals(UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            startCalDate = LocalDate.now();
        } else if (createMode.equals(UdcEnum.FIN_AR_DOC_CLS_SO.getValueCode())) {
            if (null != receiptPaymentAgreementDtlVO) {
                startCalDate = LocalDate.from(buDate);
            }
        } else if (createMode.equals(UdcEnum.FIN_AR_DOC_CLS_INVIO.getValueCode()) && null != receiptPaymentAgreementDtlVO) {
            startCalDate = LocalDate.from(buDate);
        }
        if (startCalDate == null) {
            return null;
        }
        LocalDateTime now = LocalDateTime.now();
        return now.withYear(startCalDate.getYear()).withMonth(startCalDate.getMonthValue()).withDayOfMonth(startCalDate.getDayOfMonth()).withHour(12).withMinute(0).withSecond(0);
    }

    @Override
    public LocalDateTime calculateExpirePayDate(LocalDate startCalDate, ReceiptPaymentAgreementDtlVO receiptPaymentAgreementDtlVO) {
        log.info("\u8ba1\u7b97\u5e94\u6536\u5355\u5230\u671f\u4ed8\u6b3e\u65e5\u671f,\u6536\u6b3e\u534f\u8bae\u660e\u7ec6\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)receiptPaymentAgreementDtlVO));
        LocalDate expirePayDate = null;
        if (null != startCalDate && null != receiptPaymentAgreementDtlVO && StringUtils.isNotBlank((CharSequence)receiptPaymentAgreementDtlVO.getPeriodType())) {
            expirePayDate = LocalDate.of(startCalDate.getYear(), startCalDate.getMonth(), startCalDate.getDayOfMonth());
            if (UdcEnum.AGREEMENT_PERIOD_TYPE_IMMOBILIZATION.getValueCode().equals(receiptPaymentAgreementDtlVO.getPeriodType())) {
                int effectiveAdditionalMonth = receiptPaymentAgreementDtlVO.getEffectiveAdditionalMonth() == null ? 0 : receiptPaymentAgreementDtlVO.getEffectiveAdditionalMonth();
                expirePayDate = expirePayDate.plusMonths(effectiveAdditionalMonth);
                if (receiptPaymentAgreementDtlVO.getEffectiveDate() != null) {
                    expirePayDate = receiptPaymentAgreementDtlVO.getEffectiveDate() < expirePayDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth() ? expirePayDate.withDayOfMonth(receiptPaymentAgreementDtlVO.getEffectiveDate()) : expirePayDate.withDayOfMonth(expirePayDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth());
                }
            } else if (UdcEnum.AGREEMENT_PERIOD_TYPE_ROUTINE.getValueCode().equals(receiptPaymentAgreementDtlVO.getPeriodType())) {
                if (receiptPaymentAgreementDtlVO.getValidityDateDelayDays() != null) {
                    int validityDateDelayDays = receiptPaymentAgreementDtlVO.getValidityDateDelayDays();
                    expirePayDate = expirePayDate.plusDays(validityDateDelayDays);
                }
                if (receiptPaymentAgreementDtlVO.getPeriodDays() != null) {
                    int periodDays = receiptPaymentAgreementDtlVO.getPeriodDays();
                    expirePayDate = expirePayDate.plusDays(periodDays);
                }
            }
        }
        if (expirePayDate == null) {
            return null;
        }
        LocalDateTime now = LocalDateTime.now();
        return now.withYear(expirePayDate.getYear()).withMonth(expirePayDate.getMonthValue()).withDayOfMonth(expirePayDate.getDayOfMonth()).withHour(12).withMinute(0).withSecond(0);
    }

    @Override
    public long countOverduePeriodPay(String custCode, String ouCode) {
        return this.arOrderRepoProc.countOverduePeriodPay(custCode, ouCode);
    }

    public ArOrderDomainServiceImpl(ArOrderRepo arOrderRepo, ArOrderRepoProc arOrderRepoProc, ArOrderDtlRepoProc arOrderDtlRepoProc, ArOrderDtlRepo arOrderDtlRepo, ArOrderFactory arOrderFactory, SaleInvRepo saleInvRepo, SeqNumProvider sysNumberRuleService, ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService, ReceiptPaymentAgreementDtlDomainService receiptPaymentAgreementDtlDomainService, FlexFieldUtilService flexFieldUtilService, RmiSaleRpcService rmiSaleRpcService, RmiOrderRpcService rmiOrderRpcService, ExpLedgerRepoProc expLedgerRepoProc, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService, InvStkProvider invStkProvider, InvInterTransactionDtlProvider invInterTransactionDtlProvider) {
        this.arOrderRepo = arOrderRepo;
        this.arOrderRepoProc = arOrderRepoProc;
        this.arOrderDtlRepoProc = arOrderDtlRepoProc;
        this.arOrderDtlRepo = arOrderDtlRepo;
        this.arOrderFactory = arOrderFactory;
        this.saleInvRepo = saleInvRepo;
        this.sysNumberRuleService = sysNumberRuleService;
        this.receiptPaymentAgreementDomainService = receiptPaymentAgreementDomainService;
        this.receiptPaymentAgreementDtlDomainService = receiptPaymentAgreementDtlDomainService;
        this.flexFieldUtilService = flexFieldUtilService;
        this.rmiSaleRpcService = rmiSaleRpcService;
        this.rmiOrderRpcService = rmiOrderRpcService;
        this.expLedgerRepoProc = expLedgerRepoProc;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
        this.invStkProvider = invStkProvider;
        this.invInterTransactionDtlProvider = invInterTransactionDtlProvider;
    }
}

