/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.arorder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.domain.param.arorder.ArOrderDtlPageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDtlDomainService;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArOrderDtlDomainServiceImpl
implements ArOrderDtlDomainService {
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService;

    @Override
    public PagingVO<ArOrderDtlDTO> page(ArOrderDtlPageParam arOrderDtlPageParam) {
        PagingVO<ArOrderDtlDTO> pagingVO = this.arOrderDtlRepoProc.page(arOrderDtlPageParam);
        List arOrderDtlDTOList = pagingVO.getRecords();
        if (CollectionUtil.isEmpty((Collection)arOrderDtlDTOList)) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List<String> dtlProtocolCodeList = arOrderDtlDTOList.stream().map(ArOrderDtlDTO::getProtocolCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, ReceiptPaymentAgreementVO> agreementMap = this.receiptPaymentAgreementDomainService.selectReceiptAgreementByCodes(dtlProtocolCodeList);
        this.handleApOrderDtlDTO(arOrderDtlDTOList, agreementMap);
        return PagingVO.builder().total(pagingVO.getTotal()).records(arOrderDtlDTOList).build();
    }

    private void handleApOrderDtlDTO(List<ArOrderDtlDTO> arOrderDtlDTOS, Map<String, ReceiptPaymentAgreementVO> agreementMap) {
        if (CollectionUtil.isNotEmpty(arOrderDtlDTOS)) {
            arOrderDtlDTOS.forEach(arOrderDtlDTO -> {
                ReceiptPaymentAgreementVO agreementVO;
                if (MapUtil.isNotEmpty((Map)agreementMap) && agreementMap.containsKey(arOrderDtlDTO.getProtocolCode()) && Objects.nonNull(agreementVO = (ReceiptPaymentAgreementVO)agreementMap.get(arOrderDtlDTO.getProtocolCode()))) {
                    arOrderDtlDTO.setProtocolName(agreementVO.getProtocolName());
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        Long res = this.arOrderDtlRepoProc.del(ids);
        return res;
    }

    public ArOrderDtlDomainServiceImpl(ArOrderDtlRepoProc arOrderDtlRepoProc, ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService) {
        this.arOrderDtlRepoProc = arOrderDtlRepoProc;
        this.receiptPaymentAgreementDomainService = receiptPaymentAgreementDomainService;
    }
}

