/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.factory.arorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ArOrderFactory {
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ArOrderRepoProc arOrderRepoProc;

    public PagingVO<ArOrderDTO> page(ArOrderPageParam arOrderPageParam) {
        ArrayList masIdList;
        List<Object> dtlMasIds = StringUtils.isBlank((CharSequence)arOrderPageParam.getSourceNoDtl()) ? new ArrayList() : this.arOrderDtlRepoProc.findBySourceId(arOrderPageParam.getSourceNoDtl());
        List<Long> masIdAllList = Stream.of(dtlMasIds, masIdList = CollectionUtil.isEmpty(arOrderPageParam.getDtlSourceNoList()) ? new ArrayList() : this.arOrderDtlRepoProc.findBySourceNoList(arOrderPageParam.getDtlSourceNoList())).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        PagingVO<ArOrderDTO> page = this.arOrderRepoProc.page(arOrderPageParam, masIdAllList);
        if (page != null && CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List<Long> masIds = page.getRecords().stream().map(ArOrderDTO::getId).collect(Collectors.toList());
            List<ArOrderDtlDTO> arOrderDtlDTOS = this.arOrderDtlRepoProc.listByMasIds(masIds);
            Map arOrderDtlDTOMap = arOrderDtlDTOS.stream().collect(Collectors.groupingBy(ArOrderDtlDTO::getMasId, Collectors.toList()));
            page.getRecords().stream().forEach(v -> {
                BigDecimal verAmt = BigDecimal.ZERO;
                BigDecimal verAmting = BigDecimal.ZERO;
                BigDecimal unVerAmt = BigDecimal.ZERO;
                List arOrderDtlDTOS1 = (List)arOrderDtlDTOMap.get(v.getId());
                if (CollUtil.isNotEmpty((Collection)arOrderDtlDTOS1)) {
                    for (ArOrderDtlDTO arOrderDtlDTO : arOrderDtlDTOS1) {
                        verAmt = verAmt.add(arOrderDtlDTO.getVerAmt());
                        verAmting = verAmting.add(arOrderDtlDTO.getApplyVerAmTing());
                        unVerAmt = unVerAmt.add(arOrderDtlDTO.getUnVerAmt());
                    }
                }
                v.setVerAmt(verAmt);
                v.setUnVerAmt(unVerAmt);
                if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                    v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
                } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                    v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
                } else {
                    v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
                }
            });
        }
        return page;
    }

    public Long pageCount(ArOrderPageParam arOrderPageParam) {
        List<Long> masId = this.arOrderDtlRepoProc.findBySourceId(arOrderPageParam.getSourceNoDtl());
        return 0L;
    }

    public PagingVO<ArOrderDTO> writeoffPage(ArOrderPageParam arOrderPageParam) {
        List<Long> masIds = this.arOrderDtlRepoProc.findUnverBySourceId(arOrderPageParam);
        if (CollectionUtils.isEmpty(masIds)) {
            return new PagingVO(0L, new ArrayList());
        }
        PagingVO<ArOrderDTO> page = this.arOrderRepoProc.unverPage(arOrderPageParam, masIds);
        return page;
    }

    public ArOrderFactory(ArOrderDtlRepoProc arOrderDtlRepoProc, ArOrderRepoProc arOrderRepoProc) {
        this.arOrderDtlRepoProc = arOrderDtlRepoProc;
        this.arOrderRepoProc = arOrderRepoProc;
    }
}

