/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.repo.aporder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.service.excel.entity.ApOrderExportEntity;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrderDO;
import com.elitesland.fin.domain.entity.aporder.QApOrderDO;
import com.elitesland.fin.domain.entity.aporder.QApOrderDtlDO;
import com.elitesland.fin.domain.entity.paymentperiod.QReceiptPaymentAgreementDO;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.domain.param.aporder.ApOrderParam;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.common.ApVerDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ApOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QApOrderDO qApOrderDO = QApOrderDO.apOrderDO;

    public PagingVO<ApOrderDTO> page(ApOrderPageParam apOrderPageParam, List<Long> ids) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.checkAndAddPredicates(apOrderPageParam, predicates);
        this.pageWhere(apOrderPageParam, predicates);
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getSourceNoDtl()) || CollectionUtil.isNotEmpty(apOrderPageParam.getDtlSourceNoList())) {
            if (CollectionUtil.isNotEmpty(ids)) {
                predicates.add((Predicate)this.qApOrderDO.id.in(ids));
            } else {
                return new PagingVO();
            }
        }
        if (CollectionUtil.isNotEmpty(apOrderPageParam.getInOutCustList())) {
            predicates.add((Predicate)this.qApOrderDO.inOutCust.in(apOrderPageParam.getInOutCustList()));
        }
        JPAQuery query = (JPAQuery)this.select(ApOrderDTO.class).where(ExpressionUtils.allOf(predicates));
        apOrderPageParam.setPaging(query);
        apOrderPageParam.fillOrders(query, this.qApOrderDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public PagingVO<ApOrderDTO> unverPage(ApOrderPageParam apOrderPageParam, List<Long> ids) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        apOrderPageParam.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        this.checkAndAddPredicates(apOrderPageParam, predicates);
        this.pageWhere(apOrderPageParam, predicates);
        if (CollectionUtil.isNotEmpty(ids)) {
            predicates.add((Predicate)this.qApOrderDO.id.in(ids));
        }
        if (CollectionUtil.isNotEmpty(apOrderPageParam.getInOutCustList())) {
            predicates.add((Predicate)this.qApOrderDO.inOutCust.in(apOrderPageParam.getInOutCustList()));
        }
        predicates.add((Predicate)this.qApOrderDO.orderState.ne((Object)UdcEnum.APPLY_STATUS_VOID.getValueCode()));
        JPAQuery query = (JPAQuery)this.select(ApOrderDTO.class).where(ExpressionUtils.allOf(predicates));
        apOrderPageParam.setPaging(query);
        apOrderPageParam.fillOrders(query, this.qApOrderDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private void pageWhere(ApOrderPageParam apOrderPageParam, List<Predicate> predicates) {
        Predicate customFieldPredicate;
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getAuditUser())) {
            predicates.add((Predicate)this.qApOrderDO.auditUser.like("%" + apOrderPageParam.getAuditUser() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getCreateMode())) {
            predicates.add((Predicate)this.qApOrderDO.createMode.eq((Object)apOrderPageParam.getCreateMode()));
        }
        if (null != apOrderPageParam.getInitFlag()) {
            predicates.add((Predicate)this.qApOrderDO.initFlag.eq(apOrderPageParam.getInitFlag()));
        }
        if ((customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)apOrderPageParam.getConditions(), ApOrderDO.class)) != null) {
            predicates.add(customFieldPredicate);
        }
        predicates.add((Predicate)this.qApOrderDO.deleteFlag.eq((Object)0));
    }

    private void checkAndAddPredicates(ApOrderPageParam apOrderPageParam, List<Predicate> predicates) {
        if (null != apOrderPageParam.getOuId()) {
            predicates.add((Predicate)this.qApOrderDO.ouId.eq((Object)apOrderPageParam.getOuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getOuCode())) {
            predicates.add((Predicate)this.qApOrderDO.ouCode.eq((Object)apOrderPageParam.getOuCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getCurrCode())) {
            predicates.add((Predicate)this.qApOrderDO.currCode.eq((Object)apOrderPageParam.getCurrCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getCurrName())) {
            predicates.add((Predicate)this.qApOrderDO.currName.eq((Object)apOrderPageParam.getCurrName()));
        }
        if (null != apOrderPageParam.getBuDateStart() && null != apOrderPageParam.getBuDateEnd()) {
            predicates.add((Predicate)this.qApOrderDO.buDate.between((Comparable)apOrderPageParam.getBuDateStart(), (Comparable)apOrderPageParam.getBuDateEnd()));
        }
        if (null != apOrderPageParam.getSuppId()) {
            predicates.add((Predicate)this.qApOrderDO.suppId.eq((Object)apOrderPageParam.getSuppId()));
        }
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getSuppCode())) {
            predicates.add((Predicate)this.qApOrderDO.suppCode.eq((Object)apOrderPageParam.getSuppCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getSourceNo())) {
            predicates.add((Predicate)this.qApOrderDO.sourceNo.like("%" + apOrderPageParam.getSourceNo() + "%"));
        }
        if (null != apOrderPageParam.getApTypeId()) {
            predicates.add((Predicate)this.qApOrderDO.apTypeId.eq((Object)apOrderPageParam.getApTypeId()));
        }
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getOrderState())) {
            predicates.add((Predicate)this.qApOrderDO.orderState.eq((Object)apOrderPageParam.getOrderState()));
        }
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getVerState())) {
            predicates.add((Predicate)this.qApOrderDO.verState.eq((Object)apOrderPageParam.getVerState()));
        }
        if (CollectionUtil.isNotEmpty(apOrderPageParam.getVerStateList())) {
            predicates.add((Predicate)this.qApOrderDO.verState.in(apOrderPageParam.getVerStateList()));
        }
        if (Objects.nonNull(apOrderPageParam.getProposedStatus())) {
            predicates.add((Predicate)this.qApOrderDO.proposedStatus.eq((Object)apOrderPageParam.getProposedStatus()));
        }
        if (Objects.nonNull(apOrderPageParam.getRedState())) {
            predicates.add((Predicate)this.qApOrderDO.redState.eq(apOrderPageParam.getRedState()));
        }
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getRedSourceNo())) {
            predicates.add((Predicate)this.qApOrderDO.redSourceNo.like("%" + apOrderPageParam.getRedSourceNo() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getApOrderNo())) {
            predicates.add((Predicate)this.qApOrderDO.apOrderNo.like("%" + apOrderPageParam.getApOrderNo() + "%"));
        }
        if (null != apOrderPageParam.getTotalAmtStart() && null != apOrderPageParam.getTotalAmtEnd()) {
            predicates.add((Predicate)this.qApOrderDO.totalAmt.between((Number)apOrderPageParam.getTotalAmtStart(), (Number)apOrderPageParam.getTotalAmtEnd()));
        }
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getOperator())) {
            predicates.add((Predicate)this.qApOrderDO.operator.like("%" + apOrderPageParam.getOperator() + "%"));
        }
        if (null != apOrderPageParam.getOperUserId()) {
            predicates.add((Predicate)this.qApOrderDO.operUserId.eq((Object)apOrderPageParam.getOperUserId()));
        }
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getCreator())) {
            predicates.add((Predicate)this.qApOrderDO.creator.like("%" + apOrderPageParam.getCreator() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)apOrderPageParam.getProtocolCode())) {
            predicates.add((Predicate)this.qApOrderDO.protocolCode.eq((Object)apOrderPageParam.getProtocolCode()));
        }
        if (CollectionUtil.isNotEmpty(apOrderPageParam.getProtocolCodeList())) {
            predicates.add((Predicate)this.qApOrderDO.protocolCode.in(apOrderPageParam.getProtocolCodeList()));
        }
        if (CollectionUtil.isNotEmpty(apOrderPageParam.getRelevanceOuCodeList())) {
            predicates.add((Predicate)this.qApOrderDO.relevanceOuCode.in(apOrderPageParam.getRelevanceOuCodeList()));
        }
    }

    public Boolean queryByApTypeId(Long id) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qApOrderDO.id).from((EntityPath)this.qApOrderDO)).where((Predicate)this.qApOrderDO.apTypeId.eq((Object)id))).fetchCount() > 0L;
    }

    public List<ApOrderDTO> queryByIds(List<Long> ids) {
        return ((JPAQuery)this.select(ApOrderDTO.class).where((Predicate)this.qApOrderDO.id.in(ids))).fetch();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qApOrderDO.id, this.qApOrderDO.sourceNo, this.qApOrderDO.suppId, this.qApOrderDO.suppCode, this.qApOrderDO.suppName, this.qApOrderDO.ouCode, this.qApOrderDO.ouId, this.qApOrderDO.ouName, this.qApOrderDO.apTypeId, this.qApOrderDO.apTypeName, this.qApOrderDO.apTypeCode, this.qApOrderDO.currCode, this.qApOrderDO.currName, this.qApOrderDO.operator, this.qApOrderDO.operUserId, this.qApOrderDO.buType, this.qApOrderDO.totalAmt, this.qApOrderDO.totalCurAmt, this.qApOrderDO.buDate, this.qApOrderDO.auditUserId, this.qApOrderDO.auditUser, this.qApOrderDO.auditDate, this.qApOrderDO.orderState, this.qApOrderDO.exchangeRate, this.qApOrderDO.initFlag, this.qApOrderDO.taxFlag, this.qApOrderDO.buId, this.qApOrderDO.buCode, this.qApOrderDO.buName, this.qApOrderDO.payMentCode, this.qApOrderDO.payMentName, this.qApOrderDO.payMentId, this.qApOrderDO.createTime, this.qApOrderDO.updater, this.qApOrderDO.modifyTime, this.qApOrderDO.exclTaxAmt, this.qApOrderDO.taxAmt, this.qApOrderDO.taxCurAmt, this.qApOrderDO.apOrderNo, this.qApOrderDO.creator, this.qApOrderDO.createMode, this.qApOrderDO.remark, this.qApOrderDO.localCurrCode, this.qApOrderDO.localCurrName, this.qApOrderDO.exclTaxCurAmt, this.qApOrderDO.taxRate, this.qApOrderDO.verState, this.qApOrderDO.verAmt, this.qApOrderDO.auditDataVersion, this.qApOrderDO.procInstId, this.qApOrderDO.procInstStatus, this.qApOrderDO.approvedTime, this.qApOrderDO.submitTime, this.qApOrderDO.addrNo, this.qApOrderDO.suppAddrNo, this.qApOrderDO.redState, this.qApOrderDO.redSourceId, this.qApOrderDO.redSourceNo, this.qApOrderDO.proposedStatus, this.qApOrderDO.inOutCust, this.qApOrderDO.extensionInfo, this.qApOrderDO.protocolCode, this.qApOrderDO.relevanceOuCode})).from((EntityPath)this.qApOrderDO);
    }

    public ApOrderDTO get(Long id) {
        ApOrderDTO apOrderDTO = (ApOrderDTO)((JPAQuery)this.select(ApOrderDTO.class).where((Predicate)this.qApOrderDO.id.eq((Object)id))).fetchOne();
        return apOrderDTO;
    }

    public List<ApOrderDTO> get(List<Long> ids) {
        return ((JPAQuery)this.select(ApOrderDTO.class).where((Predicate)this.qApOrderDO.id.in(ids))).fetch();
    }

    public List<ApOrderDTO> queryByVerStatus(List<String> verStatus) {
        return ((JPAQuery)this.select(ApOrderDTO.class).where((Predicate)this.qApOrderDO.verState.in(verStatus))).fetch();
    }

    public Long audit(List<Long> ids, String content, SysUserDTO user) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qApOrderDO).set(this.qApOrderDO.auditDate, (Object)LocalDateTime.now()).set((Path)this.qApOrderDO.auditRejection, (Object)content).set((Path)this.qApOrderDO.auditUser, (Object)user.getUsername()).set(this.qApOrderDO.auditUserId, (Object)user.getId()).where(new Predicate[]{this.qApOrderDO.id.in(ids)}).execute();
        return res;
    }

    public Long del(List<Long> ids) {
        long res = this.jpaQueryFactory.delete((EntityPath)this.qApOrderDO).where(new Predicate[]{this.qApOrderDO.id.in(ids)}).execute();
        return res;
    }

    public List<ApOrderDTO> getApOrderList(ApOrderParam apOrderParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (null != apOrderParam.getOuId()) {
            predicates.add(this.qApOrderDO.ouId.eq((Object)apOrderParam.getOuId()));
        }
        if (null != apOrderParam.getSuppId()) {
            predicates.add(this.qApOrderDO.suppId.eq((Object)apOrderParam.getSuppId()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)apOrderParam.getCurrCode())) {
            predicates.add(this.qApOrderDO.currCode.eq((Object)apOrderParam.getCurrCode()));
        }
        if (null != apOrderParam.getBuDateStart() && null != apOrderParam.getBuDateEnd()) {
            predicates.add(this.qApOrderDO.buDate.between((Comparable)apOrderParam.getBuDateStart(), (Comparable)apOrderParam.getBuDateEnd()));
        }
        predicates.add(this.qApOrderDO.orderState.eq((Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()));
        List fetch = ((JPAQuery)this.select(ApOrderDTO.class).where(ExpressionUtils.allOf(predicates))).fetch();
        return fetch;
    }

    public List<ApOrderDTO> selectApOrderByParam(ApOrderParam apOrderParam) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtil.isNotEmpty(apOrderParam.getApOrderNoList())) {
            predicates.add(this.qApOrderDO.apOrderNo.in(apOrderParam.getApOrderNoList()));
        }
        List fetch = ((JPAQuery)this.select(ApOrderDTO.class).where(ExpressionUtils.allOf(predicates))).fetch();
        return fetch;
    }

    public ApVerDTO queryVerAmtById(Long id) {
        return (ApVerDTO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ApVerDTO.class, (Expression[])new Expression[]{this.qApOrderDO.id, this.qApOrderDO.totalAmt, this.qApOrderDO.verAmt, this.qApOrderDO.auditDataVersion})).from((EntityPath)this.qApOrderDO)).where((Predicate)this.qApOrderDO.id.eq((Object)id))).fetchOne();
    }

    public long updateVerAmt(ApVerDTO apVerDTO) {
        return this.jpaQueryFactory.update((EntityPath)this.qApOrderDO).set((Path)this.qApOrderDO.verState, (Object)apVerDTO.getVerState()).set(this.qApOrderDO.verAmt, (Object)apVerDTO.getVerAmt()).set(this.qApOrderDO.auditDataVersion, (Object)(apVerDTO.getAuditDataVersion() + 1)).where(new Predicate[]{this.qApOrderDO.id.eq((Object)apVerDTO.getId()).and((Predicate)this.qApOrderDO.totalAmt.goe((Number)apVerDTO.getVerAmt())).and((Predicate)this.qApOrderDO.auditDataVersion.eq((Object)apVerDTO.getAuditDataVersion()))}).execute();
    }

    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qApOrderDO).set(this.qApOrderDO.procInstStatus, (Object)ProcInstStatus.APPROVING).set((Path)this.qApOrderDO.procInstId, (Object)processInfo.getProcInstId()).set(this.qApOrderDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qApOrderDO.id.eq((Object)id)});
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(this.qApOrderDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
        }
        jpaUpdateClause.execute();
    }

    public void updateSourceNo(String sourceNo, Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qApOrderDO).set((Path)this.qApOrderDO.sourceNo, (Object)sourceNo).where(new Predicate[]{this.qApOrderDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public void setNullRedFlag(Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qApOrderDO).setNull((Path)this.qApOrderDO.redState).where(new Predicate[]{this.qApOrderDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public void setRedFlag(Long id, Boolean flag) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qApOrderDO).set((Path)this.qApOrderDO.redState, (Object)flag).where(new Predicate[]{this.qApOrderDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public PagingVO<ApOrderExportEntity> defaultExport(ApOrderPageParam param) {
        QReceiptPaymentAgreementDO receiptPaymentAgreementDO = QReceiptPaymentAgreementDO.receiptPaymentAgreementDO;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.checkAndAddPredicates(param, predicates);
        this.pageWhere(param, predicates);
        QApOrderDtlDO apOrderDtlDO = QApOrderDtlDO.apOrderDtlDO;
        if (StringUtils.isNotBlank((CharSequence)param.getSourceNoDtl())) {
            predicates.add((Predicate)this.qApOrderDO.id.in((SubQueryExpression)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(apOrderDtlDO.masId).from((EntityPath)apOrderDtlDO)).where((Predicate)apOrderDtlDO.sourceNo.like("%" + param.getSourceNoDtl() + "%"))).groupBy(apOrderDtlDO.masId)));
        }
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ApOrderExportEntity.class, (Expression[])new Expression[]{this.qApOrderDO.sourceNo, this.qApOrderDO.suppCode, this.qApOrderDO.suppName, this.qApOrderDO.ouCode, this.qApOrderDO.ouName, this.qApOrderDO.apTypeName, this.qApOrderDO.apTypeCode, this.qApOrderDO.currCode, this.qApOrderDO.currName, this.qApOrderDO.operator, this.qApOrderDO.buType, this.qApOrderDO.totalAmt, this.qApOrderDO.totalCurAmt, this.qApOrderDO.buDate, this.qApOrderDO.auditUser, this.qApOrderDO.auditDate, this.qApOrderDO.orderState, this.qApOrderDO.exchangeRate, this.qApOrderDO.initFlag, this.qApOrderDO.taxFlag, this.qApOrderDO.buCode, this.qApOrderDO.buName, this.qApOrderDO.payMentCode, this.qApOrderDO.payMentName, this.qApOrderDO.createTime, this.qApOrderDO.updater, this.qApOrderDO.modifyTime, this.qApOrderDO.exclTaxAmt, this.qApOrderDO.taxAmt, this.qApOrderDO.taxCurAmt, this.qApOrderDO.apOrderNo, this.qApOrderDO.creator, this.qApOrderDO.createMode, this.qApOrderDO.remark, this.qApOrderDO.taxRate, this.qApOrderDO.verState, this.qApOrderDO.verAmt, this.qApOrderDO.approvedTime, this.qApOrderDO.submitTime, this.qApOrderDO.addrNo, this.qApOrderDO.suppAddrNo, this.qApOrderDO.redState, this.qApOrderDO.redSourceNo, this.qApOrderDO.proposedStatus, this.qApOrderDO.relevanceOuCode, this.qApOrderDO.inOutCust, apOrderDtlDO.itemId, apOrderDtlDO.itemName, apOrderDtlDO.itemCode, apOrderDtlDO.itemType, apOrderDtlDO.smallCateCode, apOrderDtlDO.smallCateName, apOrderDtlDO.uom, apOrderDtlDO.uomName, apOrderDtlDO.price, apOrderDtlDO.exclTaxPrice, apOrderDtlDO.totalAmt.as("detailTotalAmt"), apOrderDtlDO.taxAmt.as("detailTaxAmt"), apOrderDtlDO.exclTaxAmt.as("detailExclTaxAmt"), apOrderDtlDO.taxCurAmt, apOrderDtlDO.qty, apOrderDtlDO.verAmt, apOrderDtlDO.unVerAmt, apOrderDtlDO.applyVerAmTing.as("applyVerAmt"), apOrderDtlDO.sourceNo.as("detailSourceNo"), apOrderDtlDO.sourceLine, apOrderDtlDO.protocolCode, receiptPaymentAgreementDO.protocolName})).from((EntityPath)this.qApOrderDO)).leftJoin((EntityPath)apOrderDtlDO)).on((Predicate)this.qApOrderDO.id.eq(apOrderDtlDO.masId))).leftJoin((EntityPath)receiptPaymentAgreementDO)).on((Predicate)apOrderDtlDO.protocolCode.eq((Expression)receiptPaymentAgreementDO.protocolCode).and((Predicate)receiptPaymentAgreementDO.protocolType.eq((Object)UdcEnum.AGREEMENT_PROTOCOL_TYPE_PAYMENT.getValueCode())))).where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.qApOrderDO);
        param.setPaging(query);
        return new PagingVO(query.fetchCount(), query.fetch());
    }

    public List<ApOrderDTO> selectInOutCustByApOrderNo(List<String> apOrderNoList) {
        if (CollectionUtil.isEmpty(apOrderNoList)) {
            return Collections.EMPTY_LIST;
        }
        List apOrderDTOList = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ApOrderDTO.class, (Expression[])new Expression[]{this.qApOrderDO.apOrderNo, this.qApOrderDO.inOutCust, this.qApOrderDO.relevanceOuCode})).from((EntityPath)this.qApOrderDO)).where((Predicate)this.qApOrderDO.apOrderNo.in(apOrderNoList))).fetch();
        return apOrderDTOList;
    }

    public void updateVerState(String verState, Long id) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qApOrderDO).set((Path)this.qApOrderDO.verState, (Object)verState).where(new Predicate[]{this.qApOrderDO.id.eq((Object)id)});
        jpaUpdateClause.execute();
    }

    public ApOrderRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

