package com.elitesland.fin.application.web.account;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.account.AccountSnapshotParam;
import com.elitesland.fin.application.facade.vo.account.AccountBankInfoVo;
import com.elitesland.fin.application.facade.vo.account.AccountSnapshotVo;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.common.UdcEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.web.account
 * @date 2023/2/15 18:23
 */
@RestController
@RequestMapping("/fin/account")
@RequiredArgsConstructor
@Api(value = "账户", tags = {"账户"})
public class AccountController {

    private final AccountService accountService;

    @PostMapping("page")
    @ApiOperation("账户列表查询")
    public ApiResult<PagingVO<AccountVO>> page(@RequestBody AccountPageParam accountPageParam) {
        PagingVO<AccountVO> res = accountService.page(accountPageParam);
        return ApiResult.ok(res);
    }

    @PostMapping("save")
    @ApiOperation("新增/修改账户信息")
    public ApiResult<Void> save(@RequestBody AccountParam accountParam) {
        accountService.save(accountParam);
        return ApiResult.ok();
    }

    @PostMapping("enable")
    @ApiOperation("启用账户信息")
    public ApiResult<Long> enable(@RequestBody List<Long> ids) {
        AccountParam accountParam = new AccountParam();
        accountParam.setIds(ids);
        accountParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        Long res = accountService.updateState(accountParam);
        return ApiResult.ok(res);
    }

    @PostMapping("disEnable")
    @ApiOperation("禁用账户信息")
    public ApiResult<Long> disEnable(@RequestBody List<Long> ids) {
        AccountParam accountParam = new AccountParam();
        accountParam.setIds(ids);
        accountParam.setState(UdcEnum.FIN_ACTIVE_STATUS_CLOSED.getValueCode());
        Long res = accountService.updateState(accountParam);
        return ApiResult.ok(res);
    }

//    @ApiOperation("账户导入")
//    @PostMapping(value = "/import", headers = "content-type=multipart/form-data")
//    public ApiResult<Void> accountImport(MultipartFile file){
//        accountImportService.accountImport(file);
//        return ApiResult.ok();
//    }

    @GetMapping("get")
    @ApiOperation("账户列表详情")
    public ApiResult<AccountVO> get(Long id) {
        AccountVO res = accountService.get(id);
        return ApiResult.ok(res);
    }

    @ApiOperation("根据编码查询账户")
    @GetMapping("getCode")
    public ApiResult<AccountVO> getByCode(String accCode) {
        AccountVO res = accountService.getByCode(accCode);
        return ApiResult.ok(res);
    }

    @ApiOperation("根据客户编码查询银行信息")
    @GetMapping("/bank/{custCode}")
    public ApiResult<List<AccountBankInfoVo>> getBankByCustCode(@PathVariable("custCode") String custCode) {
        return ApiResult.ok(accountService.getBankByCustCode(custCode));
    }

    @ApiOperation("账户快照信息查询")
    @PostMapping("/snapshot")
    public ApiResult<PagingVO<AccountSnapshotVo>> querySnapshot(@RequestBody AccountSnapshotParam param) {
        return ApiResult.ok(accountService.querySnapshot(param));
    }

}
