package com.elitesland.fin.application.web.creditaccountflow;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import com.elitesland.fin.application.convert.creditaccountflow.CreditAccountFlowConvert;
import com.elitesland.fin.application.facade.dto.creditaccountflow.CreditAccountFlowDTO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Author gyj
 * @Date 2023/02/25
 */
@RestController
@RequestMapping("/creditAccountFlow")
@RequiredArgsConstructor
@Api(value = "信用账户流水", tags = {"信用账户流水"})
public class CreditAccountFlowController {

    private final CreditAccountFlowService creditAccountFlowService;

    @PostMapping("/page")
    @ApiOperation("信用账户流水分页查询")
    public ApiResult<PagingVO<CreditAccountFlowVO>> page(@RequestBody CreditAccountFlowParam creditAccountFlowParam) {

        PagingVO<CreditAccountFlowDTO> creditAccountFlowDTOPagingVO = creditAccountFlowService.page(creditAccountFlowParam);
        PagingVO<CreditAccountFlowVO> creditAccountFlowVOPagingVO = CreditAccountFlowConvert.INSTANCE
                .creditAccountFlowDTOPagingVO2CreditAccountFlowVOPagingVO(creditAccountFlowDTOPagingVO);

        return ApiResult.ok(creditAccountFlowVOPagingVO);
    }

    @PostMapping("/approve")
    @ApiOperation("审批通过")
    public ApiResult<List<Void>> approve(@RequestBody CreditAccountFlowParam creditAccountFlowParam) {
        creditAccountFlowService.approve(creditAccountFlowParam);
        return ApiResult.ok();
    }

    @PostMapping("/reject")
    @ApiOperation("审批拒绝")
    public ApiResult<List<Void>> reject(@RequestBody CreditAccountFlowParam creditAccountFlowParam) {
        creditAccountFlowService.reject(creditAccountFlowParam);
        return ApiResult.ok();
    }
}
