package com.elitesland.fin.domain.entity.aporder;

import cn.hutool.core.lang.Assert;
import com.elitesland.fin.common.UdcEnum;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.entity.aporder
 * @date 2022/3/16 10:48
 */
@Data
public class ApOrderDtl {

    private Long masId;

    private String sourceNo;

    private Integer sourceLine;

    private Long itemId;

    private String itemCode;

    private String itemName;

    private String itemType;

    private String smallCateCode;

    private String smallCateName;

    private String uom;

    private String uomName;

    private BigDecimal qty;

    private BigDecimal exclTaxPrice;

    private BigDecimal price;

    private BigDecimal taxRate;

    private BigDecimal totalAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal taxAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal exclTaxCurAmt;

    private BigDecimal taxCurAmt;

    private String remark;


    /**
     * 字段必填校验
     */
    public void check(String createMode) {
        // 手工状态校验
        if (createMode.equals(UdcEnum.FIN_AP_DOC_CLS_MANU.getValueCode())) {
            // 商品信息
            Assert.notNull(this.itemId, "商品信息 itemId is null");
            Assert.notEmpty(this.itemCode, "商品信息 itemCode is null");
            Assert.notEmpty(this.itemName, "商品信息 itemName is null");
            // 单位信息
            Assert.notEmpty(this.uom, "单位信息 uom is null");
            Assert.notEmpty(this.uomName, "单位信息 uomName is null");
            // 小类编码/名称
            Assert.notEmpty(this.smallCateCode, "小类编码 smallCateCode is null");
            Assert.notEmpty(this.smallCateName, "小类名称 smallCateName is null");
            // 税额
            Assert.notNull(this.taxRate, "税额 taxRate is null");
            // 税额（本位币）
            Assert.notNull(this.taxCurAmt, "税额(本位币) taxCurAmt is null");
            // 数量
            Assert.notNull(this.qty, "数量 qty is null");
            if (new BigDecimal("0").compareTo(this.qty) == 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "数量不能为0 !");
            }
            // 含税单价
            Assert.notNull(this.price, "含税单价 price is null");
            if (this.price.compareTo(BigDecimal.ZERO) < 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "含税单价需大于等于0 !");
            }
            // 不含税单价
            Assert.notNull(this.exclTaxPrice, "不含税单价 exclTaxPrice is null");
            if (this.exclTaxPrice.compareTo(BigDecimal.ZERO) < 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "不含税单价需大于等于0 !");
            }
            // 税率
            Assert.notNull(this.taxAmt, "税率 taxAmt is null");
            // 不含税金额
            Assert.notNull(this.exclTaxAmt, "不含税金额 exclTaxAmt is null");
            Assert.notNull(this.exclTaxCurAmt, "不含税金额(本位币) exclTaxCurAmt is null");
        }
        // 对账单
        if (createMode.equals(UdcEnum.FIN_AP_DOC_CLS_PACCK.getValueCode())) {
            Assert.notEmpty(this.sourceNo, "来源单号 sourceNo is null");
            Assert.notNull(this.sourceLine, "来源行号 sourceLine is null");
            Assert.notNull(this.itemId, "商品信息 itemId is null");
            Assert.notEmpty(this.itemCode, "商品信息 itemCode is null");
            Assert.notEmpty(this.itemName, "商品信息 itemName is null");
            Assert.notEmpty(this.itemType, "规格型号 itemType is null");
            Assert.notEmpty(this.uom, "单位信息 uom is null");
            Assert.notEmpty(this.uomName, "单位信息 uomName is null");
            Assert.notNull(this.qty, "数量 qty is null");
            Assert.notNull(this.exclTaxPrice, "不含税单价 exclTaxPrice is null");
            Assert.notNull(this.price, "含税单价 price is null");
            Assert.notNull(this.totalAmt, "含税金额 totalAmt is null");
            Assert.notNull(this.taxAmt, "税率 taxAmt is null");
            Assert.notNull(this.taxRate, "税额 taxRate is null");
            Assert.notNull(this.exclTaxAmt, "不含税金额 exclTaxAmt is null");

            Assert.notEmpty(this.smallCateCode, "小类编码 smallCateCode is null");
            Assert.notEmpty(this.smallCateName, "小类名称 smallCateName is null");
        }
    }

}
