package com.elitesland.fin.infr.dto.saleinv;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-5-6
 * @desc : 销售发票明细
 */
@Data
public class SaleInvDtlDTO extends BaseViewModel implements Serializable {

    private static final long serialVersionUID = 5339900349745486590L;
    private Long id;

    private Long masId;

    private String taxName;

    private String taxCode;

    private String invNature;

    private String sourceNo;

    private Long sourceId;

    private Integer sourceLine;

    private Long sourceLineId;

    private Long itemId;

    private String itemName;

    private String itemCode;

    private String itemType;

    private String uom;

    private String uomName;

    private BigDecimal qty;

    private BigDecimal price;

    private BigDecimal totalAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal taxRate;

    private BigDecimal taxAmt;

    private BigDecimal taxCurAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal exclTaxCurAmt;

    private String invType;

    private String invKind;

    private String examType;

    private String creator;

    private LocalDateTime createTime;

    private LocalDateTime modifyTime;

    @ApiModelProperty("返利冲抵金额")
    private BigDecimal flDeductionAmt;

    @ApiModelProperty("票扣含税金额")
    private BigDecimal invDiscountAmt;

    @ApiModelProperty("折扣额")
    private BigDecimal discountAmt;

    @ApiModelProperty("可开票含税金额")
    private BigDecimal invAmt;

    @ApiModelProperty("发/收货单号")
    private String docNo;

    @ApiModelProperty("发货/收货单明细id")
    private Long relateDocDid;

    @ApiModelProperty("来源单据明细表ID")
    private Long optDocDtlId;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户姓名")
    private String custName;

    @ApiModelProperty("发货日期")
    private LocalDateTime shipTime;

    @ApiModelProperty("签收日期")
    private LocalDateTime confirmTime;

    @ApiModelProperty("销/退订单号")
    private String logisDocNo;

    @ApiModelProperty("订单类型")
    private String relateDocType;

    @ApiModelProperty("订单日期")
    private LocalDateTime soDate;

    @ApiModelProperty("下单渠道类型")
    private String soSource;

    @ApiModelProperty("是否赠品")
    private String giftsFlag;

    @ApiModelProperty("本次对账数量")
    private BigDecimal soaQty;

    @ApiModelProperty("折扣后主含税单价")
    private BigDecimal discountPrice;

    @ApiModelProperty("对账含税金额")
    private BigDecimal soaAmt;

    @ApiModelProperty("发票折扣率")
    private BigDecimal invDiscount;

    @ApiModelProperty("可开票税额")
    private BigDecimal invTaxAmt;

    @ApiModelProperty("可开票未税金额")
    private BigDecimal invNetAmt;

    @ApiModelProperty("原主含税单价")
    private BigDecimal mainPrice;

    @ApiModelProperty("单品折扣")
    private BigDecimal itemDiscount;

    @ApiModelProperty("业务员员工名字")
    private String agentName;

    @ApiModelProperty("业务员员工ID")
    private Long agentEmpId;

    @ApiModelProperty("收货联系人")
    private String recvContactName;

    @ApiModelProperty("收货联系电话")
    private String recvContactTel;

    @ApiModelProperty("收货详细地址")
    private String recvDetailaddr;

    @ApiModelProperty("主客户编码")
    private String mainCustCode;

    @ApiModelProperty("主客户名称")
    private String mainCustName;

    @ApiModelProperty("主客户id")
    private Long mainCustId;

    @ApiModelProperty("待开发票id")
    private Long invoiceAwaitId;

    @ApiModelProperty("发票号码")
    private String invNo;

	@ApiModelProperty("推送NC的applyNo")
	private String ncApplyNo;

//    @ApiModelProperty("商品编码")
//    private String itemCode;
//
//    @ApiModelProperty("单位")
//    private String uom;

//    @ApiModelProperty("辅单位")
//    private String uom2;

//    @ApiModelProperty("数量")
//    private String qty;
//
//    @ApiModelProperty("辅数量")
//    private BigDecimal qty2;
//
//    @ApiModelProperty("含税单价")
//    private String price;


//    @ApiModelProperty("主未税单价")
//    private BigDecimal es5;
//
//    @ApiModelProperty("辅含税单价")
//    private BigDecimal price2;
//
//    @ApiModelProperty("辅未税单价")
//    private BigDecimal es7;

//    @ApiModelProperty("不含税总金额")
//    private BigDecimal exclTaxAmt;
//    @ApiModelProperty("税额")
//    private String taxAmt;
//    @ApiModelProperty("税率")
//    private String taxRate;

    //    @ApiModelProperty("含税金额")
//    private BigDecimal totalAmt;
//
//    @ApiModelProperty("折扣额")
//    private BigDecimal discountAmt;

//    @ApiModelProperty("来源单号ID")
//    private String sourceId;

//    @ApiModelProperty("整单折扣")
//    private BigDecimal es9;
//
//    @ApiModelProperty("单品折扣")
//    private BigDecimal es10;
//
//    @ApiModelProperty("发票折扣")
//    private BigDecimal es11;
//
//    @ApiModelProperty("票扣前金额")
//    private BigDecimal es12;
//
//    @ApiModelProperty("票扣金额")
//    private BigDecimal es13;
//
//    @ApiModelProperty("赠品")
//    private String es14;
//
//    @ApiModelProperty("客户编码")
//    private String es15;
//
//    @ApiModelProperty("客户编码")
//    private String es16;
//
//    @ApiModelProperty("扣税类别")
//    private String es17;
//
//    @ApiModelProperty("NC销售订单号")
//    private String es18;
//
//    @ApiModelProperty("销售渠道类型")
//    private String es19;

}