package com.elitesland.fin.utils;

import com.elitesland.fin.common.FinConstant;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class StringUtil {

    public static String buildLikeString(String string) {
        return string == null ? null : FinConstant.PERCENTAGE.concat(string).concat(FinConstant.PERCENTAGE);

    }

    public static String convertToCamelCase(String input) {
        StringBuilder result = new StringBuilder();

        // 使用split()方法将字符串分割成单词
        String[] words = input.split("_");

        for (String word : words) {
            // 首字母小写
            if (result.length() == 0) {
                result.append(word.toLowerCase());
            } else {
                // 首字母大写
                result.append(Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase());
            }
        }
        return result.toString();
    }
}
