/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.account;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.AccountRuleConfigConvert;
import com.elitesland.fin.application.convert.account.AccountRuleConfigDtlConvert;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.dto.account.AccountIocDTO;
import com.elitesland.fin.application.facade.dto.account.AccountRuleConfigDTO;
import com.elitesland.fin.application.facade.dto.account.AccountRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.account.AccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.account.AccountRuleConfigSaveParam;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigDtlVO;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigQueryVO;
import com.elitesland.fin.application.service.account.AccountRuleConfigService;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.account.AccountIocDomainService;
import com.elitesland.fin.domain.service.account.AccountRuleConfigDomainService;
import com.elitesland.fin.domain.service.account.AccountRuleConfigDtlDomainService;
import com.elitesland.fin.entity.account.AccountRuleConfigDO;
import com.elitesland.fin.entity.account.AccountRuleConfigDtlDO;
import com.elitesland.fin.repo.account.AccountRuleConfigDtlRepo;
import com.elitesland.fin.repo.account.AccountRuleConfigRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
public class AccountRuleConfigServiceImpl
implements AccountRuleConfigService {
    private static final Logger log = LoggerFactory.getLogger(AccountRuleConfigServiceImpl.class);
    private final AccountRuleConfigDomainService accountRuleConfigDomainService;
    private final AccountRuleConfigDtlDomainService accountRuleConfigDtlDomainService;
    private final AccountIocDomainService accountIocDomainService;
    private final RedissonClient redissonClient;
    private final AccountRuleConfigRepo accountRuleConfigRepo;
    private final AccountRuleConfigDtlRepo accountRuleConfigDtlRepo;
    private final UdcProvider udcProvider;
    private final AccountService accountService;
    private final RedisUtils redisUtils;

    @Override
    @SysCodeProc
    public PagingVO<AccountRuleConfigPageVO> searchPage(AccountRuleConfigQueryParam param) {
        PagingVO<AccountRuleConfigPageVO> accountRuleConfigPageVOPagingVO = this.accountRuleConfigDomainService.searchPage(param);
        if (CollectionUtil.isNotEmpty((Collection)accountRuleConfigPageVOPagingVO.getRecords())) {
            this.convertPage(accountRuleConfigPageVOPagingVO.getRecords());
        }
        this.pageCode2Name(accountRuleConfigPageVOPagingVO.getRecords());
        return accountRuleConfigPageVOPagingVO;
    }

    @Override
    public void saveOrUpdate(AccountRuleConfigSaveParam param) {
        this.validateSaveOrUpdateParam(param);
        this.persistence(param);
        this.redisUtils.del(new String[]{"YST_FIN_ACCOUNT_RULE_CONFIG"});
    }

    private void persistence(AccountRuleConfigSaveParam param) {
        this.checkRepeatData(param);
        this.checkExist(param);
        if (param.getId() == null) {
            this.saveConfigAndDtl(param);
            return;
        }
        this.updateConfigAndDtl(param);
    }

    private void checkExist(AccountRuleConfigSaveParam param) {
        List<AccountRuleConfigDO> accountRuleConfigDOList = this.accountRuleConfigRepo.findAllByRuleCode(param.getRuleCode());
        if (CollectionUtils.isNotEmpty(accountRuleConfigDOList)) {
            Assert.isTrue((accountRuleConfigDOList.size() == 1 ? 1 : 0) != 0, (String)"\u5b58\u5728\u591a\u6761\u76f8\u540c\u7684\u89c4\u5219\u7f16\u7801", (Object[])new Object[0]);
            Assert.equals((Object)accountRuleConfigDOList.get(0).getId(), (Object)param.getId(), (String)"\u89c4\u5219\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
        if (CollectionUtils.isNotEmpty(accountRuleConfigDOList = this.accountRuleConfigRepo.findAllByOptDoc(param.getOptDoc()))) {
            Assert.isTrue((accountRuleConfigDOList.size() == 1 ? 1 : 0) != 0, (String)"\u5b58\u5728\u591a\u6761\u76f8\u540c\u7684\u9002\u7528\u5355\u636e", (Object[])new Object[0]);
            Assert.equals((Object)accountRuleConfigDOList.get(0).getId(), (Object)param.getId(), (String)"\u9002\u7528\u5355\u636e\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
    }

    private void checkRepeatData(AccountRuleConfigSaveParam param) {
        HashMap seq = new HashMap();
        param.getAccountRuleConfigDtlDTOList().stream().forEach(item -> {
            Assert.isNull(seq.get(item.getPriorityNo()), (String)"\u4f18\u5148\u7ea7\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
            seq.put(item.getPriorityNo(), "");
        });
        HashSet repeatSet = new HashSet();
        param.getAccountRuleConfigDtlDTOList().stream().forEach(item -> Arrays.stream(item.getOptDocType().split("\\+")).forEach(optDocType -> {
            if (StringUtils.isNotEmpty((CharSequence)item.getSpecificAccount())) {
                Arrays.stream(item.getSpecificAccount().split("\\+")).forEach(specificAccount -> {
                    String uniqueKey = item.getIoCode().concat((String)optDocType).concat(item.getOptDocStatus()).concat(item.getOptAccountType()).concat((String)specificAccount);
                    Assert.isFalse((boolean)repeatSet.contains(uniqueKey), (String)"\u5b58\u5728\u91cd\u590d\u89c4\u5219,\u4e8b\u52a1\u7801\u3001\u9002\u7528\u5355\u636e\u7c7b\u578b\u3001\u9002\u7528\u5355\u636e\u72b6\u6001\u3001\u9002\u7528\u8d26\u6237\u7c7b\u578b\u3001\u6307\u5b9a\u8d26\u6237\u9700\u552f\u4e00", (Object[])new Object[0]);
                    repeatSet.add(uniqueKey);
                });
            } else {
                String uniqueKey = item.getIoCode().concat((String)optDocType).concat(item.getOptDocStatus()).concat(item.getOptAccountType());
                Assert.isFalse((boolean)repeatSet.contains(uniqueKey), (String)"\u5b58\u5728\u91cd\u590d\u89c4\u5219,\u4e8b\u52a1\u7801\u3001\u9002\u7528\u5355\u636e\u7c7b\u578b\u3001\u9002\u7528\u5355\u636e\u72b6\u6001\u3001\u9002\u7528\u8d26\u6237\u7c7b\u578b\u3001\u6307\u5b9a\u8d26\u6237\u9700\u552f\u4e00", (Object[])new Object[0]);
                repeatSet.add(uniqueKey);
            }
        }));
        repeatSet.stream().forEach(item -> repeatSet.stream().forEach(item1 -> {
            if (item.contains((CharSequence)item1) && !StringUtils.equals((CharSequence)item, (CharSequence)item1)) {
                Assert.isTrue((boolean)false, (String)"\u5b58\u5728\u91cd\u590d\u89c4\u5219,\u4e8b\u52a1\u7801\u3001\u9002\u7528\u5355\u636e\u7c7b\u578b\u3001\u9002\u7528\u5355\u636e\u72b6\u6001\u3001\u6307\u5b9a\u8d26\u6237\u9700\u552f\u4e00", (Object[])new Object[0]);
            }
        }));
    }

    private void updateConfigAndDtl(AccountRuleConfigSaveParam param) {
        AccountRuleConfigDO accountRuleConfigDO = AccountRuleConfigConvert.INSTANCE.param2DO(param);
        List<AccountRuleConfigDtlDO> accountRuleConfigDtlDOS = AccountRuleConfigDtlConvert.INSTANCE.param2DOList(param.getAccountRuleConfigDtlDTOList());
        accountRuleConfigDtlDOS.stream().forEach(dtl -> dtl.setMasId(accountRuleConfigDO.getId()));
        this.accountRuleConfigDomainService.updateDynamically(accountRuleConfigDO);
        this.accountRuleConfigDtlDomainService.deleteByParam(this.getQueryBeanByMasId(accountRuleConfigDO.getId()));
        this.accountRuleConfigDtlDomainService.saveAll(accountRuleConfigDtlDOS);
    }

    private Long saveConfigAndDtl(AccountRuleConfigSaveParam param) {
        AccountRuleConfigDO accountRuleConfigDO = AccountRuleConfigConvert.INSTANCE.param2DO(param);
        List<AccountRuleConfigDtlDO> accountRuleConfigDtlDOS = AccountRuleConfigDtlConvert.INSTANCE.param2DOList(param.getAccountRuleConfigDtlDTOList());
        this.accountRuleConfigRepo.save(accountRuleConfigDO);
        accountRuleConfigDtlDOS.forEach(dtl -> dtl.setMasId(accountRuleConfigDO.getId()));
        this.accountRuleConfigDtlRepo.saveAll(accountRuleConfigDtlDOS);
        return accountRuleConfigDO.getId();
    }

    private void validateSaveOrUpdateParam(AccountRuleConfigSaveParam param) {
        Assert.notEmpty((CharSequence)param.getRuleCode(), (String)"\u8d26\u6237\u89c4\u5219\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getRuleName(), (String)"\u8d26\u6237\u89c4\u5219\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getOptDoc(), (String)"\u9002\u7528\u5355\u636e\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getStatus(), (String)"\u542f\u7528\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty(param.getAccountRuleConfigDtlDTOList(), (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        param.getAccountRuleConfigDtlDTOList().stream().forEach(item -> {
            Assert.notNull((Object)item.getPriorityNo(), (String)"\u4f18\u5148\u7ea7\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getIoCode(), (String)"\u4e8b\u52a1\u7801\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getIoName(), (String)"\u4e8b\u52a1\u7801\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getOptDocType(), (String)"\u9002\u7528\u5355\u636e\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getOptDocStatus(), (String)"\u9002\u7528\u5355\u636e\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getOptAccountType(), (String)"\u9002\u7528\u8d26\u6237\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notNull((Object)item.getCalculatePercent(), (String)"\u8ba1\u7b97\u6bd4\u4f8b\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notNull((Object)item.isAutomaticReview(), (String)"\u6d41\u6c34\u81ea\u52a8\u5ba1\u6838\u5fc5\u586b", (Object[])new Object[0]);
        });
    }

    @Override
    public void del(Long id) {
        Optional<AccountRuleConfigDO> accountRuleConfigDOOptional = this.accountRuleConfigDomainService.findById(id);
        if (accountRuleConfigDOOptional.isPresent()) {
            AccountRuleConfigDO dbSceneConfig = accountRuleConfigDOOptional.get();
            this.accountRuleConfigDtlDomainService.deleteByCondition(this.getQueryBeanByMasId(id));
            this.accountRuleConfigDomainService.deleteById(id);
            this.removeCache(dbSceneConfig.getRuleCode());
            this.redisUtils.del(new String[]{"YST_FIN_ACCOUNT_RULE_CONFIG"});
        }
    }

    private AccountRuleConfigDtlDO getQueryBeanByMasId(Long id) {
        AccountRuleConfigDtlDO whereBean = new AccountRuleConfigDtlDO();
        whereBean.setMasId(id);
        return whereBean;
    }

    @Override
    @SysCodeProc
    public AccountRuleConfigQueryVO detail(Long masId) {
        Optional dbConfig = this.accountRuleConfigRepo.findById(masId);
        if (!dbConfig.isPresent()) {
            return null;
        }
        AccountRuleConfigQueryVO queryVO = AccountRuleConfigConvert.INSTANCE.do2VO((AccountRuleConfigDO)dbConfig.get());
        List<AccountRuleConfigDtlDO> all = this.accountRuleConfigDtlDomainService.findAccountRuleConfigDtlByMasId(masId);
        List<AccountRuleConfigDtlVO> accountRuleConfigDtlVoList = AccountRuleConfigDtlConvert.INSTANCE.do2VOList(all);
        this.detailCode2Name(accountRuleConfigDtlVoList);
        queryVO.setAccountRuleConfigDtlVoList(accountRuleConfigDtlVoList);
        return queryVO;
    }

    public void detailCode2Name(List<AccountRuleConfigDtlVO> accountRuleConfigDtlVOList) {
        Map docClsUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.DOC_CLS_SO_C.getModel(), UdcEnum.DOC_CLS_SO_C.getCode());
        Map docStatusUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.DOC_STATUS_RSO_CL.getModel(), UdcEnum.DOC_STATUS_RSO_CL.getCode());
        Map accountTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.ACCOUNT_TYPE_STORE.getModel(), UdcEnum.ACCOUNT_TYPE_STORE.getCode());
        HashSet<String> accountCodeSet = new HashSet<String>();
        accountRuleConfigDtlVOList.stream().forEach(item -> {
            if (StringUtils.isNotEmpty((CharSequence)item.getSpecificAccount())) {
                String[] specificAccountArray = item.getSpecificAccount().split("\\+");
                Arrays.stream(specificAccountArray).forEach(specificAccount -> accountCodeSet.add((String)specificAccount));
            }
        });
        List<Object> accountDTOList = new ArrayList();
        if (CollectionUtils.isNotEmpty(accountCodeSet)) {
            AccountParam accountParam = new AccountParam();
            accountParam.setAccountCodes(accountCodeSet);
            accountDTOList = this.accountService.getAccountByAccountParam(accountParam);
            Assert.notEmpty(accountDTOList, (String)"\u67e5\u8be2\u8d26\u6237\u540d\u79f0\u5931\u8d25", (Object[])new Object[0]);
        }
        ArrayList optDocTypeList = new ArrayList();
        ArrayList specificAccountList = new ArrayList();
        ArrayList finalAccountDTOList = accountDTOList;
        accountRuleConfigDtlVOList.stream().forEach(item -> {
            optDocTypeList.clear();
            specificAccountList.clear();
            String[] optDocTypeArray = item.getOptDocType().split("\\+");
            Arrays.stream(optDocTypeArray).forEach(optDocType -> optDocTypeList.add((String)docClsUdc.get(optDocType)));
            if (StringUtils.isNotEmpty((CharSequence)item.getSpecificAccount())) {
                String[] specificAccountArray = item.getSpecificAccount().split("\\+");
                Arrays.stream(specificAccountArray).forEach(specificAccount -> {
                    AccountDTO result = finalAccountDTOList.stream().filter(accountVO -> specificAccount.equals(accountVO.getAccountCode())).findFirst().orElse(null);
                    if (result != null) {
                        specificAccountList.add(result.getAccountName());
                    }
                });
            }
            item.setOptDocTypeName(this.joinedWithPlus(optDocTypeList));
            if (CollectionUtils.isNotEmpty((Collection)specificAccountList)) {
                item.setSpecificAccountName(this.joinedWithPlus(specificAccountList));
            }
            item.setOptDocStatusName((String)docStatusUdc.get(item.getOptDocStatus()));
            item.setOptAccountTypeName((String)accountTypeUdc.get(item.getOptAccountType()));
        });
    }

    public void pageCode2Name(List<AccountRuleConfigPageVO> accountRuleConfigPageVOList) {
        Map docClsUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.DOC_CLS_SO_C.getModel(), UdcEnum.DOC_CLS_SO_C.getCode());
        Map docStatusUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.DOC_STATUS_RSO_CL.getModel(), UdcEnum.DOC_STATUS_RSO_CL.getCode());
        ArrayList optDocTypeList = new ArrayList();
        accountRuleConfigPageVOList.stream().forEach(item -> {
            optDocTypeList.clear();
            String[] optDocTypeArray = item.getOptDocType().split("\\+");
            Arrays.stream(optDocTypeArray).forEach(optDocType -> optDocTypeList.add((String)docClsUdc.get(optDocType)));
            item.setOptDocTypeName(this.joinedWithPlus(optDocTypeList));
            item.setOptDocStatusName((String)docStatusUdc.get(item.getOptDocStatus()));
        });
    }

    private String joinedWithPlus(List<String> param) {
        return StringUtils.join(param, (String)"+");
    }

    private void removeCache(String ruleCode) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_RULE_CONFIG_KEY_" + ruleCode);
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    @Override
    public AccountRuleConfigDTO getByRuleCode(String ruleCode) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_RULE_CONFIG_KEY_" + ruleCode);
        if (bucket.isExists()) {
            return (AccountRuleConfigDTO)bucket.get();
        }
        AccountRuleConfigDTO dbConfig = this.accountRuleConfigDomainService.findByRuleCode(ruleCode);
        if (dbConfig != null) {
            Example dtlExample = Example.of((Object)this.getQueryBeanByMasId(dbConfig.getId()));
            List<AccountRuleConfigDtlDO> all = this.accountRuleConfigDtlDomainService.findAll(dtlExample);
            List<AccountRuleConfigDtlDTO> accountRuleConfigDtls = AccountRuleConfigDtlConvert.INSTANCE.do2DTOList(all);
            dbConfig.setAccountRuleConfigDtlDTOList(accountRuleConfigDtls);
            bucket.set((Object)dbConfig);
            return dbConfig;
        }
        return null;
    }

    @Override
    public PagingVO<AccountRuleConfigPageVO> searchPageWithOutName(AccountRuleConfigQueryParam param) {
        PagingVO<AccountRuleConfigPageVO> accountRuleConfigPageVOPagingVO = this.accountRuleConfigDomainService.searchPage(param);
        return accountRuleConfigPageVOPagingVO;
    }

    private void convertPage(List<AccountRuleConfigPageVO> accountRuleConfigDtls) {
        List<AccountIocDTO> accountIocNameList = this.accountIocDomainService.findByCodeBatch(accountRuleConfigDtls.stream().map(AccountRuleConfigPageVO::getIoCode).collect(Collectors.toList()));
        Map<Object, Object> ioCodeMap = new HashMap();
        Map<Object, Object> ioTypeMap = new HashMap();
        if (CollectionUtils.isNotEmpty(accountIocNameList)) {
            ioTypeMap = accountIocNameList.stream().collect(Collectors.toMap(AccountIocDTO::getIoType, i -> i.getIoTypeName() == null ? "" : i.getIoTypeName(), (key1, key2) -> key2));
            ioCodeMap = accountIocNameList.stream().collect(Collectors.toMap(AccountIocDTO::getIoCode, i -> i.getIoName() == null ? "" : i.getIoName(), (key1, key2) -> key2));
        }
        for (AccountRuleConfigPageVO configDtl : accountRuleConfigDtls) {
            if (!StringUtils.isNotBlank((CharSequence)configDtl.getIoCode())) continue;
            configDtl.setIoName((String)ioCodeMap.get(configDtl.getIoCode()));
        }
    }

    public AccountRuleConfigServiceImpl(AccountRuleConfigDomainService accountRuleConfigDomainService, AccountRuleConfigDtlDomainService accountRuleConfigDtlDomainService, AccountIocDomainService accountIocDomainService, RedissonClient redissonClient, AccountRuleConfigRepo accountRuleConfigRepo, AccountRuleConfigDtlRepo accountRuleConfigDtlRepo, UdcProvider udcProvider, AccountService accountService, RedisUtils redisUtils) {
        this.accountRuleConfigDomainService = accountRuleConfigDomainService;
        this.accountRuleConfigDtlDomainService = accountRuleConfigDtlDomainService;
        this.accountIocDomainService = accountIocDomainService;
        this.redissonClient = redissonClient;
        this.accountRuleConfigRepo = accountRuleConfigRepo;
        this.accountRuleConfigDtlRepo = accountRuleConfigDtlRepo;
        this.udcProvider = udcProvider;
        this.accountService = accountService;
        this.redisUtils = redisUtils;
    }
}

