/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.exp;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.excel.entity.PayOrderExportEntity;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DefaultPayOrderExportServiceImpl
implements DataExport<PayOrderExportEntity, PayOrderPageParam> {
    private final PayOrderDomainService payOrderDomainService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    public String getTmplCode() {
        return "FIN_PAY_EXPORT_DEFAULT";
    }

    @SysCodeProc
    public PagingVO<PayOrderExportEntity> executeExport(PayOrderPageParam queryParam) {
        PagingVO<PayOrderExportEntity> page = this.payOrderDomainService.exportPayOrder(queryParam);
        List records = page.getRecords();
        if (CollUtil.isEmpty((Collection)records)) {
            return new PagingVO();
        }
        List<String> relOuCodes = records.stream().map(PayOrderExportEntity::getRelevanceOuCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relOuCodes);
        records.forEach(row -> {
            OrgOuRpcSimpleDTO ouRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(row.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)) {
                row.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }
        });
        return new PagingVO(page.getTotal(), ExcelConvertUtils.convertLoosely(records, PayOrderExportEntity.class));
    }

    public Integer pageSize() {
        return 1000;
    }

    public DefaultPayOrderExportServiceImpl(PayOrderDomainService payOrderDomainService, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService) {
        this.payOrderDomainService = payOrderDomainService;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
    }
}

