/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.invoice.await;

import com.elitesland.fin.enums.InvoiceAwaitTypeEnum;
import com.elitesland.fin.provider.invoice.await.InvoiceAwaitSaveService;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class InvoiceAwaitSaveServiceFactory
implements InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(InvoiceAwaitSaveServiceFactory.class);
    private final Map<InvoiceAwaitTypeEnum, InvoiceAwaitSaveService> PAYMENT_RECORDS_SERVICE_MAP = new HashMap<InvoiceAwaitTypeEnum, InvoiceAwaitSaveService>();
    private ApplicationContext appContext;

    public void afterPropertiesSet() {
        this.appContext.getBeansOfType(InvoiceAwaitSaveService.class).values().forEach(strategy -> this.PAYMENT_RECORDS_SERVICE_MAP.put(strategy.getPaymentRecordStrategy(), (InvoiceAwaitSaveService)strategy));
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    public InvoiceAwaitSaveService initialService(InvoiceAwaitTypeEnum invoiceAwaitTypeEnum) {
        return this.PAYMENT_RECORDS_SERVICE_MAP.get(invoiceAwaitTypeEnum);
    }
}

