/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinSobAccountPeriodConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinSobAccountPeriodDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinSobAccountPeriodParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinSobAccountPeriodVO;
import com.elitesland.fin.application.service.accountingengine.FinSobAccountPeriodService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountPeriodDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountPeriodLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookOuDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSobAccountPeriodDO;
import com.elitesland.fin.repo.accountingengine.FinAccountPeriodLineRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountPeriodRepoProc;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookOuRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepoProc;
import com.elitesland.fin.repo.accountingengine.FinSobAccountPeriodRepo;
import com.elitesland.fin.repo.accountingengine.FinSobAccountPeriodRepoProc;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinSobAccountPeriodServiceImpl
implements FinSobAccountPeriodService {
    private static final Logger log = LoggerFactory.getLogger(FinSobAccountPeriodServiceImpl.class);
    private final FinSobAccountPeriodRepo finSobAccountPeriodRepo;
    private final FinSobAccountPeriodRepoProc finSobAccountPeriodRepoProc;
    private final FinSetOfBookRepoProc finSetOfBookRepoProc;
    private final FinAccountPeriodRepoProc finAccountPeriodRepoProc;
    private final FinAccountPeriodLineRepo finAccountPeriodLineRepo;
    private final FinSetOfBookOuRepo finSetOfBookOuRepo;

    @Override
    @SysCodeProc
    public PagingVO<FinSobAccountPeriodVO> page(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        return FinSobAccountPeriodConvert.INSTANCE.DTOToVO(this.finSobAccountPeriodRepoProc.page(finSobAccountPeriodParam));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generate(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        this.checkGenerateParam(finSobAccountPeriodParam);
        List<FinSobAccountPeriodDO> finSobAccountPeriodDOList = this.buildGenerateList(finSobAccountPeriodParam);
        List<FinSobAccountPeriodDTO> finSobAccountPeriodDTOList = this.finSobAccountPeriodRepoProc.query(finSobAccountPeriodParam);
        finSobAccountPeriodDOList = finSobAccountPeriodDOList.stream().filter(finSobAccountPeriodDO -> !finSobAccountPeriodDTOList.stream().filter(finSobAccountPeriodDTO -> finSobAccountPeriodDTO.getSobCode().equals(finSobAccountPeriodDO.getSobCode()) && finSobAccountPeriodDTO.getAccountPeriodCode().equals(finSobAccountPeriodDO.getAccountPeriodCode()) && finSobAccountPeriodDTO.getOuCode().equals(finSobAccountPeriodDO.getOuCode()) && finSobAccountPeriodDTO.getActiveStartTime().equals(finSobAccountPeriodDO.getActiveStartTime()) && finSobAccountPeriodDTO.getActiveEndTime().equals(finSobAccountPeriodDO.getActiveEndTime())).findFirst().isPresent()).collect(Collectors.toList());
        this.finSobAccountPeriodRepo.saveAll(finSobAccountPeriodDOList);
    }

    private void checkGenerateParam(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        Assert.notEmpty((CharSequence)finSobAccountPeriodParam.getSobCode(), (String)"\u8d26\u5957\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finSobAccountPeriodParam.getYear(), (String)"\u5e74\u4efd\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty(finSobAccountPeriodParam.getOuCodeList(), (String)"\u516c\u53f8\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
    }

    private List<FinSobAccountPeriodDO> buildGenerateList(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        FinSetOfBookDO finSetOfBookDO = this.finSetOfBookRepoProc.findBySobCode(finSobAccountPeriodParam.getSobCode());
        Assert.notNull((Object)"\u8d26\u5957\u4e0d\u5b58\u5728");
        FinAccountPeriodDO finAccountPeriodDO = this.finAccountPeriodRepoProc.findByAccountPeriodCode(finSetOfBookDO.getAccountPeriodCode());
        Assert.notNull((Object)"\u6761\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728");
        List<FinAccountPeriodLineDO> finAccountPeriodLineDOList = this.finAccountPeriodLineRepo.findAllByMasIdIn(Lists.newArrayList((Object[])new Long[]{finAccountPeriodDO.getId()}));
        List<FinSetOfBookOuDO> finSetOfBookOuDOList = this.finSetOfBookOuRepo.findAllByMasIdIn(Lists.newArrayList((Object[])new Long[]{finSetOfBookDO.getId()}));
        List<String> ouCodeList = finSobAccountPeriodParam.getOuCodeList();
        List<FinSobAccountPeriodDO> finSobAccountPeriodDOList = ouCodeList.stream().flatMap(ouCode -> finAccountPeriodLineDOList.stream().filter(finAccountPeriodLineDO -> finSobAccountPeriodParam.getYear().equals(finAccountPeriodLineDO.getYear())).map(finAccountPeriodLineDO -> {
            FinSobAccountPeriodDO finSobAccountPeriodDO = new FinSobAccountPeriodDO();
            finSobAccountPeriodDO.setSobCode(finSetOfBookDO.getSobCode());
            finSobAccountPeriodDO.setSobName(finSetOfBookDO.getSobName());
            finSobAccountPeriodDO.setAccountPeriodCode(finAccountPeriodDO.getAccountPeriodCode());
            finSobAccountPeriodDO.setAccountPeriodName(finAccountPeriodDO.getAccountPeriodName());
            finSobAccountPeriodDO.setOuCode((String)ouCode);
            FinSetOfBookOuDO finSetOfBookOuDOResult = finSetOfBookOuDOList.stream().filter(finSetOfBookOuDO -> finSetOfBookOuDO.getOuCode().equals(ouCode)).findFirst().orElse(null);
            Assert.notNull((Object)finSetOfBookOuDOResult, (String)"\u516c\u53f8\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            finSobAccountPeriodDO.setOuName(finSetOfBookOuDOResult.getOuName());
            finSobAccountPeriodDO.setPeriodStyle(finAccountPeriodLineDO.getPeriodStyle());
            finSobAccountPeriodDO.setStatus(UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_NOT_OPEN.getValueCode());
            finSobAccountPeriodDO.setActiveStartTime(finAccountPeriodLineDO.getActiveStartTime());
            finSobAccountPeriodDO.setActiveEndTime(finAccountPeriodLineDO.getActiveEndTime());
            return finSobAccountPeriodDO;
        })).collect(Collectors.toList());
        return finSobAccountPeriodDOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void openOrClose(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        this.checkEnableOrDisableParam(finSobAccountPeriodParam);
        List finSobAccountPeriodDOList = this.finSobAccountPeriodRepo.findAllById(finSobAccountPeriodParam.getIds());
        finSobAccountPeriodDOList.stream().forEach(item -> {
            if (StrUtil.equals((CharSequence)item.getStatus(), (CharSequence)UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_NOT_OPEN.getValueCode()) && StrUtil.equals((CharSequence)item.getStatus(), (CharSequence)UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_OPEN.getValueCode())) {
                throw new BusinessException("\u5df2\u5173\u95ed\u7684\u4e0d\u80fd\u518d\u6253\u5f00");
            }
            Assert.isFalse((boolean)finSobAccountPeriodParam.getStatus().equals(item.getStatus()), (String)"\u5df2\u6253\u5f00/\u5173\u95ed", (Object[])new Object[0]);
        });
        finSobAccountPeriodDOList.stream().forEach(item -> item.setStatus(finSobAccountPeriodParam.getStatus()));
    }

    private void checkEnableOrDisableParam(FinSobAccountPeriodParam finSobAccountPeriodParam) {
        Assert.notEmpty(finSobAccountPeriodParam.getIds(), (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finSobAccountPeriodParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
    }

    public FinSobAccountPeriodServiceImpl(FinSobAccountPeriodRepo finSobAccountPeriodRepo, FinSobAccountPeriodRepoProc finSobAccountPeriodRepoProc, FinSetOfBookRepoProc finSetOfBookRepoProc, FinAccountPeriodRepoProc finAccountPeriodRepoProc, FinAccountPeriodLineRepo finAccountPeriodLineRepo, FinSetOfBookOuRepo finSetOfBookOuRepo) {
        this.finSobAccountPeriodRepo = finSobAccountPeriodRepo;
        this.finSobAccountPeriodRepoProc = finSobAccountPeriodRepoProc;
        this.finSetOfBookRepoProc = finSetOfBookRepoProc;
        this.finAccountPeriodRepoProc = finAccountPeriodRepoProc;
        this.finAccountPeriodLineRepo = finAccountPeriodLineRepo;
        this.finSetOfBookOuRepo = finSetOfBookOuRepo;
    }
}

