/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountreport;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountreport.AccountReportConvert;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.accountreport.AccountReportPageParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountPageParam;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.facade.vo.accountreport.AccountReportVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountPageVO;
import com.elitesland.fin.application.service.accountreport.AccountReportService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.utils.SysUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class AccountReportServiceImpl
implements AccountReportService {
    private final AccountRepoProc accountRepoProc;
    private final CreditAccountRepoProc creditAccountRepoProc;

    private BigDecimal setScale(BigDecimal bigDecimal, Integer amtRound) {
        return bigDecimal.setScale((int)amtRound, RoundingMode.HALF_UP);
    }

    @Override
    public PagingVO<AccountReportVO> page(AccountReportPageParam accountReportPageParam) {
        CreditAccountPageParam creditAccountPageParam = new CreditAccountPageParam();
        creditAccountPageParam.setOuCode(accountReportPageParam.getOuCode());
        creditAccountPageParam.setObjectCode(accountReportPageParam.getCustCode());
        creditAccountPageParam.setCreditAccountLimitStart(accountReportPageParam.getCreditAccountLimitStart());
        creditAccountPageParam.setCreditAccountLimitEnd(accountReportPageParam.getCreditAccountLimitEnd());
        creditAccountPageParam.setIds(accountReportPageParam.getIds());
        List<CreditAccountPageVO> creditAccountPageVOList = this.creditAccountRepoProc.queryList(creditAccountPageParam);
        AccountPageParam accountPageParam = new AccountPageParam();
        accountPageParam.setSecOuCode(accountReportPageParam.getOuCode());
        accountPageParam.setAccountHolderCode(accountReportPageParam.getCustCode());
        List<AccountVO> accountVOList = this.accountRepoProc.queryList(accountPageParam);
        Map<String, AccountVO> accountVOMap = accountVOList.stream().collect(Collectors.toMap(item -> {
            if (UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType())) {
                return item.getSecOuCode() + item.getAccountHolderCode() + UdcEnum.ACCOUNT_TYPE_STORE.getValueCode();
            }
            if (UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType())) {
                return item.getSecOuCode() + item.getAccountHolderCode() + UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode();
            }
            return null;
        }, item -> item));
        Integer amtRound = SysUtils.getAmtPlace();
        Map<Long, AccountReportVO> accountReportVOMap = creditAccountPageVOList.stream().map(item -> {
            AccountReportVO accountReportVO = new AccountReportVO();
            accountReportVO.setId(item.getId());
            accountReportVO.setOuCode(item.getOuCode());
            accountReportVO.setOuName(item.getOuName());
            accountReportVO.setCustCode(item.getObjectCode());
            accountReportVO.setCustName(item.getObjectName());
            accountReportVO.setCreditAccountLimit(this.setScale(this.nullDefaultZero(item.getCreditAccountLimit()), amtRound));
            accountReportVO.setCreditAccountUsedLimit(this.setScale(this.nullDefaultZero(item.getCreditAccountUsedLimit()), amtRound));
            accountReportVO.setCreditAccountOccupancyLimit(this.setScale(this.nullDefaultZero(item.getCreditAccountOccupancyLimit()), amtRound));
            accountReportVO.setCreditAccountAvailableLimit(this.setScale(this.nullDefaultZero(item.getCreditAccountAvailableLimit()), amtRound));
            String uniqueKey = item.getOuCode() + item.getObjectCode();
            AccountVO accountVO = (AccountVO)accountVOMap.get(uniqueKey + UdcEnum.ACCOUNT_TYPE_STORE.getValueCode());
            accountReportVO.setStorageAccountAmount(this.setScale(accountVO.getAccountAmount(), amtRound));
            accountReportVO.setStorageAccountOccupancyAmount(this.setScale(accountVO.getAccountOccupancyAmount(), amtRound));
            accountReportVO.setStorageAccountAvailableAmount(this.setScale(accountVO.getAccountAvailableAmount(), amtRound));
            accountVO = (AccountVO)accountVOMap.get(uniqueKey + UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode());
            accountReportVO.setRebateAccountAmount(this.setScale(accountVO.getAccountAmount(), amtRound));
            accountReportVO.setRebateAccountOccupancyAmount(this.setScale(accountVO.getAccountOccupancyAmount(), amtRound));
            accountReportVO.setRebateAccountAvailableAmount(this.setScale(accountVO.getAccountAvailableAmount(), amtRound));
            this.calculateAmount(accountReportVO, amtRound);
            BigDecimal unremittedAmountStart = accountReportPageParam.getUnremittedAmountStart();
            if (unremittedAmountStart != null && accountReportVO.getUnremittedAmount().compareTo(unremittedAmountStart) < 0) {
                return null;
            }
            BigDecimal unremittedAmountEnd = accountReportPageParam.getUnremittedAmountEnd();
            if (unremittedAmountEnd != null && accountReportVO.getUnremittedAmount().compareTo(unremittedAmountEnd) > 0) {
                return null;
            }
            return accountReportVO;
        }).filter(Objects::nonNull).collect(Collectors.toMap(BaseModelVO::getId, item -> item));
        if (accountReportVOMap.size() == 0) {
            return PagingVO.builder().total(0L).records((List)Lists.newArrayList()).build();
        }
        creditAccountPageParam = AccountReportConvert.INSTANCE.param2Param(accountReportPageParam);
        creditAccountPageParam.setCurrent(accountReportPageParam.current);
        creditAccountPageParam.setIds(Lists.newArrayList(accountReportVOMap.keySet()));
        PagingVO<CreditAccountPageVO> creditAccountPageVOPagingVO = this.creditAccountRepoProc.search(creditAccountPageParam);
        List accountReportVOList = creditAccountPageVOPagingVO.getRecords().stream().map(item -> (AccountReportVO)accountReportVOMap.get(item.getId())).collect(Collectors.toList());
        return PagingVO.builder().total((long)accountReportVOMap.size()).records(accountReportVOList).build();
    }

    private void calculateAmount(AccountReportVO accountReportVO, Integer amtRound) {
        accountReportVO.setAvailableAmount(this.setScale(accountReportVO.getStorageAccountAvailableAmount().add(accountReportVO.getRebateAccountAvailableAmount()).add(accountReportVO.getCreditAccountAvailableLimit()), amtRound));
        BigDecimal unremittedAmount = accountReportVO.getCreditAccountUsedLimit().add(accountReportVO.getCreditAccountOccupancyLimit()).subtract(accountReportVO.getStorageAccountAvailableAmount());
        accountReportVO.setUnremittedAmount(unremittedAmount.compareTo(BigDecimal.ZERO) > 0 ? unremittedAmount : BigDecimal.ZERO);
        accountReportVO.setUnremittedAmount(this.setScale(accountReportVO.getUnremittedAmount(), amtRound));
    }

    private BigDecimal nullDefaultZero(BigDecimal bigDecimal) {
        return Optional.ofNullable(bigDecimal).orElse(BigDecimal.ZERO);
    }

    public AccountReportServiceImpl(AccountRepoProc accountRepoProc, CreditAccountRepoProc creditAccountRepoProc) {
        this.accountRepoProc = accountRepoProc;
        this.creditAccountRepoProc = creditAccountRepoProc;
    }
}

