/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.adjusttoorder;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.log.model.bo.OperationLogDTO;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.adjusttoorder.AdjustToOrderConvert;
import com.elitesland.fin.application.facade.param.adjusttoorder.AdjustToOrderParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.SaveFlowParam;
import com.elitesland.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.fin.application.service.adjusttoorder.AdjustToOrderService;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.common.SysNumEnum;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.entity.adjusttoorder.AdjustToOrderDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.adjusttoorder.AdjustToOrderRepo;
import com.elitesland.fin.repo.adjusttoorder.AdjustToOrderRepoProc;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdjustToOrderServiceImpl
implements AdjustToOrderService {
    private final AdjustToOrderRepo adjustToOrderRepo;
    private final AdjustToOrderRepoProc adjustToOrderRepoProc;
    private final AccountRepoProc accountRepoProc;
    private final SysNumberGenerator sysNumberGenerator;
    private final AccountFlowService accountFlowService;
    private final CreditAccountFlowService creditAccountFlowService;
    private final AccountRepo accountRepo;
    private final UdcProvider udcProvider;
    private final OperationLogMqMessageService operationLogMqMessageService;

    @Override
    @SysCodeProc
    public PagingVO<AdjustToOrderVO> page(AdjustToOrderParam adjustOrderPageParam) {
        return AdjustToOrderConvert.INSTANCE.DTO2VO(this.adjustToOrderRepoProc.page(adjustOrderPageParam));
    }

    @Override
    @SysCodeProc
    public AdjustToOrderVO getOne(Long id) {
        return this.adjustToOrderRepoProc.queryById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long approve(Long id) {
        AdjustToOrderDO adjustToOrderDO = this.adjustToOrderRepoProc.findById(id);
        Assert.equals((Object)UdcEnum.APPLY_STATUS_DOING.getValueCode(), (Object)adjustToOrderDO.getDocState(), (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u5355\u636e\u624d\u53ef\u5ba1\u6279!", (Object[])new Object[0]);
        this.buildAdjustToOrderDO(adjustToOrderDO, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
        Map udcCode = this.udcProvider.getValueMapByUdcCode(UdcEnum.ACCOUNT_TYPE_STORE.getModel(), Set.of(UdcEnum.ACCOUNT_TYPE_STORE.getCode(), UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getCode()));
        Map accountTypeMap = (Map)udcCode.get(UdcEnum.ACCOUNT_TYPE_STORE.getCode());
        Map creditAccountTypeMap = (Map)udcCode.get(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getCode());
        this.generateAccountFlow(adjustToOrderDO, adjustToOrderDO.getAccountCodeFrom(), UdcEnum.ADJUST_TYPE_2.getValueCode());
        if (accountTypeMap.containsKey(adjustToOrderDO.getAccountTypeTo())) {
            this.generateAccountFlow(adjustToOrderDO, adjustToOrderDO.getAccountCodeTo(), UdcEnum.ADJUST_TYPE_1.getValueCode());
        } else if (creditAccountTypeMap.containsKey(adjustToOrderDO.getAccountTypeTo())) {
            this.generateCreditAccountFlow(adjustToOrderDO);
        } else {
            throw new BusinessException(String.format("\u81f3\u8d26\u6237\u7c7b\u578b%s\u6ca1\u6709\u7ef4\u62a4", adjustToOrderDO.getAccountTypeTo()));
        }
        OperationLogDTO dto = this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_AdjustTo:\u8d26\u6237\u8c03\u5242\u5355", adjustToOrderDO.getDocNo(), OperationTypeEnum.APPROVE_OK, "\u5ba1\u6279\u901a\u8fc7");
        this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
        return id;
    }

    private void buildAdjustToOrderDO(AdjustToOrderDO adjustToOrderDO, String state) {
        SysUserDTO user = this.getUser();
        adjustToOrderDO.setDocState(state);
        adjustToOrderDO.setAuditTime(LocalDateTime.now());
        adjustToOrderDO.setAuditUser(user.getUsername());
        adjustToOrderDO.setAuditUserId(user.getId());
    }

    @Override
    public void generateAccountFlow(AdjustToOrderDO adjustToOrderDO, String accountCode, String docType) {
        AccountFlowParam accountFlowParam = new AccountFlowParam();
        accountFlowParam.setSourceDoc(UdcEnum.DOC_CLS_ATO.getValueCode());
        accountFlowParam.setSourceDocType(docType);
        accountFlowParam.setSourceDocStatus(adjustToOrderDO.getDocState());
        accountFlowParam.setSourceDocAmount(adjustToOrderDO.getAdjustAmount());
        accountFlowParam.setSourceId(adjustToOrderDO.getId());
        accountFlowParam.setSourceNo(adjustToOrderDO.getDocNo());
        accountFlowParam.setAccountCode(accountCode);
        accountFlowParam.setOverOneFlow(Boolean.TRUE);
        this.accountFlowService.generateAccountFlow(accountFlowParam);
    }

    @Override
    public void generateCreditAccountFlow(AdjustToOrderDO adjustToOrderDO) {
        CreditAccountFlowParam creditAccountFlowParam = new CreditAccountFlowParam();
        creditAccountFlowParam.setSourceDoc(UdcEnum.DOC_CLS_ATO.getValueCode());
        creditAccountFlowParam.setSourceDocType(UdcEnum.ADJUST_TYPE_1.getValueCode());
        creditAccountFlowParam.setSourceDocStatus(adjustToOrderDO.getDocState());
        creditAccountFlowParam.setSourceDocAmount(adjustToOrderDO.getAdjustAmount());
        creditAccountFlowParam.setSourceId(adjustToOrderDO.getId());
        creditAccountFlowParam.setSourceNo(adjustToOrderDO.getDocNo());
        creditAccountFlowParam.setCreditAccountCode(adjustToOrderDO.getAccountCodeTo());
        this.creditAccountFlowService.generateCreditAccountFlow(creditAccountFlowParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long reject(AdjustToOrderParam param) {
        Assert.notNull((Object)param.getId(), (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        AdjustToOrderDO adjustToOrderDO = this.adjustToOrderRepoProc.findById(param.getId());
        Assert.equals((Object)UdcEnum.APPLY_STATUS_DOING.getValueCode(), (Object)adjustToOrderDO.getDocState(), (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u5355\u636e\u624d\u53ef\u62d2\u7edd!", (Object[])new Object[0]);
        this.buildAdjustToOrderDO(adjustToOrderDO, UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode());
        if (StringUtils.isNotEmpty((CharSequence)param.getAuditRejectReason())) {
            adjustToOrderDO.setAuditRejectReason(param.getAuditRejectReason());
        }
        this.generateAccountFlow(adjustToOrderDO, adjustToOrderDO.getAccountCodeFrom(), UdcEnum.ADJUST_TYPE_2.getValueCode());
        OperationLogDTO dto = this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_AdjustTo:\u8d26\u6237\u8c03\u5242\u5355", adjustToOrderDO.getDocNo(), OperationTypeEnum.APPROVE_REJECT, "\u5ba1\u6279\u62d2\u7edd");
        this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
        return param.getId();
    }

    @Override
    public Long saveOrUpdate(AdjustToOrderParam adjustOrderParam) {
        this.checkSave(adjustOrderParam);
        if (adjustOrderParam.getId() == null) {
            String docNo = this.sysNumberGenerator.generate(SysNumEnum.FIN_ADJTO_ORDER.getCode());
            AdjustToOrderDO adjustToOrderDO = AdjustToOrderConvert.INSTANCE.paramToDO(adjustOrderParam);
            adjustToOrderDO.setDocNo(docNo);
            this.adjustToOrderRepo.save((Object)adjustToOrderDO);
            OperationLogDTO dto = this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_AdjustTo:\u8d26\u6237\u8c03\u5242\u5355", docNo, OperationTypeEnum.ADD, "\u65b0\u589e\u8c03\u5242\u5355");
            this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
            return adjustToOrderDO.getId();
        }
        AdjustToOrderDO adjustToOrderDO = this.adjustToOrderRepoProc.findById(adjustOrderParam.getId());
        this.checkAdjustToOrderState(adjustToOrderDO);
        AdjustToOrderConvert.INSTANCE.paramToDO(adjustOrderParam, adjustToOrderDO);
        this.adjustToOrderRepo.save((Object)adjustToOrderDO);
        OperationLogDTO dto = this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_AdjustTo:\u8d26\u6237\u8c03\u5242\u5355", adjustToOrderDO.getDocNo(), OperationTypeEnum.UPDATE, "\u4fee\u6539\u8c03\u5242\u5355");
        this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
        return adjustToOrderDO.getId();
    }

    private void checkAdjustToOrderState(AdjustToOrderDO adjustToOrderDO) {
        Assert.equals((Object)adjustToOrderDO.getDocState(), (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode(), (String)"\u5f53\u524d\u72b6\u6001\u65e0\u6cd5\u7f16\u8f91", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void submit(Long id) {
        AdjustToOrderDO adjustToOrderDO = this.adjustToOrderRepoProc.findById(id);
        adjustToOrderDO.setDocState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        AccountDO accountDO = this.accountRepoProc.findByAccountCode(adjustToOrderDO.getAccountCodeFrom());
        if (NumberUtil.isGreater((BigDecimal)adjustToOrderDO.getAdjustAmount(), (BigDecimal)accountDO.getAccountAvailableAmount())) {
            throw new BusinessException(String.format("\u8c03\u51fa\u91d1\u989d%s\u5927\u4e8e\u8d26\u6237\u53ef\u7528\u989d\u5ea6%s", adjustToOrderDO.getAdjustAmount().setScale(2, RoundingMode.HALF_UP), accountDO.getAccountAvailableAmount().setScale(2, RoundingMode.HALF_UP)));
        }
        OperationLogDTO dto = this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_AdjustTo:\u8d26\u6237\u8c03\u5242\u5355", adjustToOrderDO.getDocNo(), OperationTypeEnum.APPROVE_SUBMIT, "\u5ba1\u6279\u63d0\u4ea4");
        this.generateAccountFlow(adjustToOrderDO, adjustToOrderDO.getAccountCodeFrom(), UdcEnum.ADJUST_TYPE_2.getValueCode());
        this.adjustToOrderRepo.save((Object)adjustToOrderDO);
        this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
    }

    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            throw new BusinessException("\u5f53\u524d\u767b\u9646\u4eba\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a!");
        }
        return userDetails.getUser();
    }

    @Override
    public void checkSave(AdjustToOrderParam adjustToOrderParam) {
        Assert.notEmpty((CharSequence)adjustToOrderParam.getAdjustReason(), (String)"\u8c03\u6574\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustToOrderParam.getAccountNameFrom(), (String)"\u4ece\u8d26\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustToOrderParam.getAccountCodeFrom(), (String)"\u4ece\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustToOrderParam.getAccountTypeFrom(), (String)"\u4ece\u8d26\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustToOrderParam.getAccountCodeTo(), (String)"\u81f3\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)adjustToOrderParam.getAccountTypeTo(), (String)"\u81f3\u8d26\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        if (adjustToOrderParam.getAccountCodeFrom().equals(adjustToOrderParam.getAccountCodeTo())) {
            throw new BusinessException("\u4ece\u8d26\u6237\u548c\u81f3\u8d26\u6237\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a!");
        }
        if (adjustToOrderParam.getAdjustAmount().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BusinessException("\u8c03\u6574\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0");
        }
    }

    private void saveFlow(SaveFlowParam saveFlowParam) {
        String transactionType = "";
        String dataSource = "";
        String transactionType2 = "";
        String dataSource2 = "";
        ArrayList<AccountFlowParam> param = new ArrayList<AccountFlowParam>();
        AccountFlowParam accountFlowParam = new AccountFlowParam();
        accountFlowParam.setAmount(saveFlowParam.getTotalAmt());
        accountFlowParam.setAccCode(saveFlowParam.getAccCodeFrom());
        accountFlowParam.setAccName(saveFlowParam.getAccNameFrom());
        accountFlowParam.setSplitType("ADJUST_APPROVE_FROM");
        accountFlowParam.setSourceNo(saveFlowParam.getDocNo());
        accountFlowParam.setSourceDoc(UdcEnum.FIN_SOURCE_DOC_TYPE_TJD.getValueCode());
        accountFlowParam.setAccType(saveFlowParam.getAccTypeFrom());
        accountFlowParam.setTransactionTime(saveFlowParam.getTime());
        accountFlowParam.setSourcePlatform(UdcEnum.FIN_SOURCE_PLATFORM_TYPE_FIN.getValueCode());
        AccountFlowParam accountFlowParam2 = new AccountFlowParam();
        accountFlowParam2.setAmount(saveFlowParam.getTotalAmt());
        accountFlowParam2.setAccCode(saveFlowParam.getAccCodeTo());
        accountFlowParam2.setAccName(saveFlowParam.getAccNameTo());
        accountFlowParam2.setSplitType("ADJUST_APPROVE_TO");
        accountFlowParam2.setSourceNo(saveFlowParam.getDocNo());
        accountFlowParam2.setSourceDoc(UdcEnum.FIN_SOURCE_DOC_TYPE_TJD.getValueCode());
        accountFlowParam2.setAccType(saveFlowParam.getAccTypeTo());
        accountFlowParam2.setTransactionTime(saveFlowParam.getTime());
        accountFlowParam2.setSourcePlatform(UdcEnum.FIN_SOURCE_PLATFORM_TYPE_FIN.getValueCode());
        if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) && saveFlowParam.getScene().equals("SUBMIT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) && saveFlowParam.getScene().equals("REJECT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_ZCFLZH.getValueCode())) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode())) && saveFlowParam.getScene().equals("SUBMIT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode())) && saveFlowParam.getScene().equals("REJECT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode();
        } else if ((saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJCZZH.getValueCode()) || saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_PJFLZH.getValueCode())) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
        } else if (saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()) && saveFlowParam.getScene().equals("SUBMIT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDZY.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD01.getValueCode();
        } else if (saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()) && saveFlowParam.getScene().equals("REJECT")) {
            transactionType = UdcEnum.FIN_TRANSACTION_TYPE_TJDSF.getValueCode();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD02.getValueCode();
        } else if (saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_FJCZZH.getValueCode()) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
        } else if (saveFlowParam.getAccTypeFrom().equals(UdcEnum.FIN_ACCOUNT_TYPE_TCZH.getValueCode()) && saveFlowParam.getScene().equals("APPROVED")) {
            transactionType = saveFlowParam.getAdjReason();
            dataSource = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
            transactionType2 = saveFlowParam.getAdjReason();
            dataSource2 = UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode();
        }
        accountFlowParam.setTransactionType(transactionType);
        accountFlowParam.setDataSource(dataSource);
        accountFlowParam2.setTransactionType(transactionType2);
        accountFlowParam2.setDataSource(dataSource2);
        if (!StringUtils.isEmpty((CharSequence)transactionType2) && !StringUtils.isEmpty((CharSequence)dataSource2)) {
            param.add(accountFlowParam2);
        }
        if (!StringUtils.isEmpty((CharSequence)transactionType) && !StringUtils.isEmpty((CharSequence)dataSource)) {
            param.add(accountFlowParam);
        }
        if (!CollectionUtils.isEmpty(param)) {
            this.accountFlowService.save(param);
        }
    }

    public AdjustToOrderServiceImpl(AdjustToOrderRepo adjustToOrderRepo, AdjustToOrderRepoProc adjustToOrderRepoProc, AccountRepoProc accountRepoProc, SysNumberGenerator sysNumberGenerator, AccountFlowService accountFlowService, CreditAccountFlowService creditAccountFlowService, AccountRepo accountRepo, UdcProvider udcProvider, OperationLogMqMessageService operationLogMqMessageService) {
        this.adjustToOrderRepo = adjustToOrderRepo;
        this.adjustToOrderRepoProc = adjustToOrderRepoProc;
        this.accountRepoProc = accountRepoProc;
        this.sysNumberGenerator = sysNumberGenerator;
        this.accountFlowService = accountFlowService;
        this.creditAccountFlowService = creditAccountFlowService;
        this.accountRepo = accountRepo;
        this.udcProvider = udcProvider;
        this.operationLogMqMessageService = operationLogMqMessageService;
    }
}

