/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.flowrepair;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.flowrepair.CreditAccountFlowRepairHandleDTO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.flowrepair.CreditAccountFlowRepairPageParam;
import com.elitesland.fin.application.facade.param.flowrepair.CreditAccountFlowRepairParam;
import com.elitesland.fin.application.facade.param.flowrepair.CreditAccountFlowRepairRedoParam;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.application.facade.vo.flowrepair.CreditAccountFlowRepairVO;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.flowrepair.CreditAccountFlowRepairService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.creditaccount.CreditAccountDO;
import com.elitesland.fin.entity.flowrepair.CreditAccountFlowRepairDO;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepoProc;
import com.elitesland.fin.repo.flowrepair.CreditAccountFlowRepairRepo;
import com.elitesland.fin.repo.flowrepair.CreditAccountFlowRepairRepoProc;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreditAccountFlowRepairServiceImpl
implements CreditAccountFlowRepairService {
    private static final Logger log = LoggerFactory.getLogger(CreditAccountFlowRepairServiceImpl.class);
    @Autowired
    private CreditAccountFlowRepairRepo creditAccountFlowRepairRepo;
    @Autowired
    private CreditAccountFlowRepairRepoProc creditAccountFlowRepairRepoProc;
    @Autowired
    private CreditAccountFlowService creditAccountFlowService;
    @Autowired
    private CreditAccountFlowRepoProc creditAccountFlowRepoProc;
    @Autowired
    private CreditAccountRepoProc creditAccountRepoProc;
    private final RedissonClient redissonClient;

    @Override
    @SysCodeProc
    public PagingVO<CreditAccountFlowRepairVO> page(CreditAccountFlowRepairPageParam pageParam) {
        PagingVO<CreditAccountFlowRepairVO> pagingVO = this.creditAccountFlowRepairRepoProc.page(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        return PagingVO.builder().total(pagingVO.getTotal()).records(pagingVO.getRecords()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(CreditAccountFlowRepairParam param) {
        if (StringUtils.isBlank((CharSequence)param.getFlowNo())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (Objects.isNull(param.getActualAmount())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5b9e\u9645\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        CreditAccountFlowVO flowVO = this.selectFlowByFlowNo(param.getFlowNo());
        if (Objects.isNull(param.getId())) {
            CreditAccountFlowRepairDO flowRepairDO = new CreditAccountFlowRepairDO();
            this.assembleFlowRepair(flowRepairDO, param, flowVO);
            this.creditAccountFlowRepairRepo.save((Object)flowRepairDO);
        } else {
            Optional flowRepairOptional = this.creditAccountFlowRepairRepo.findById(param.getId());
            if (flowRepairOptional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6b64\u6761\u6d41\u6c34\u4fee\u590d\u6570\u636e!");
            }
            CreditAccountFlowRepairDO flowRepairDO = (CreditAccountFlowRepairDO)((Object)flowRepairOptional.get());
            if (!Objects.equals(flowRepairDO.getRepairStatus(), UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8349\u7a3f\u72b6\u6001\u624d\u53ef\u4fee\u6539!");
            }
            this.assembleFlowRepair(flowRepairDO, param, flowVO);
            this.creditAccountFlowRepairRepo.save((Object)flowRepairDO);
        }
    }

    private void assembleFlowRepair(CreditAccountFlowRepairDO flowRepairDO, CreditAccountFlowRepairParam param, CreditAccountFlowVO flowVO) {
        flowRepairDO.setFlowNo(param.getFlowNo());
        flowRepairDO.setActualAmount(param.getActualAmount());
        flowRepairDO.setAmount(flowVO.getAmount());
        flowRepairDO.setOpenAccountEntityCode(flowVO.getObjectCode());
        flowRepairDO.setOpenAccountEntityName(flowVO.getObjectName());
        flowRepairDO.setAccountType(flowVO.getCreditAccountType());
        flowRepairDO.setAccountCode(flowVO.getCreditAccountCode());
        flowRepairDO.setAccountName(flowVO.getCreditAccountName());
        flowRepairDO.setSourceNo(flowVO.getSourceNo());
        flowRepairDO.setRepairStatus(UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode());
    }

    private CreditAccountFlowVO selectFlowByFlowNo(String flowNo) {
        if (StringUtils.isBlank((CharSequence)flowNo)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6d41\u6c34\u53f7\u4e3a\u7a7a!");
        }
        CreditAccountFlowParam flowQueryParam = new CreditAccountFlowParam();
        flowQueryParam.setFlowNo(flowNo);
        List<CreditAccountFlowVO> flowVOList = this.creditAccountFlowService.selectListByQueryParam(flowQueryParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6b64\u6d41\u6c34\u53f7(" + flowNo + ")\u7684\u6d41\u6c34\u4fe1\u606f!");
        }
        if (CollectionUtils.isNotEmpty(flowVOList) && flowVOList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6b64\u6d41\u6c34\u53f7(" + flowNo + ")\u7684\u5b58\u5728\u591a\u6761\u6d41\u6c34\u4fe1\u606f!");
        }
        return flowVOList.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        CreditAccountFlowRepairPageParam flowRepairPageParam = new CreditAccountFlowRepairPageParam();
        flowRepairPageParam.setIds(ids);
        List<CreditAccountFlowRepairVO> respVOList = this.creditAccountFlowRepairRepoProc.selectListByParam(flowRepairPageParam);
        if (CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        List voList = respVOList.stream().filter(respVO -> !Objects.equals(respVO.getRepairStatus(), UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(voList)) {
            String checkResult = voList.stream().map(vo -> "\u6d41\u6c34\u53f7:" + vo.getFlowNo()).collect(Collectors.joining(";", "\u53ea\u6709\u8349\u7a3f\u53ef\u5220\u9664,[", "], \u8bf7\u68c0\u67e5"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        this.creditAccountFlowRepairRepoProc.updateDeleteFlagBatch(1, ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void repairRedo(CreditAccountFlowRepairRedoParam repairRedoParam) {
        CreditAccountFlowRepairPageParam flowRepairPageParam = new CreditAccountFlowRepairPageParam();
        flowRepairPageParam.setIds(repairRedoParam.getIds());
        flowRepairPageParam.setFlowNoList(repairRedoParam.getFlowNoList());
        flowRepairPageParam.setRepairStatus(UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode());
        List<CreditAccountFlowRepairVO> repairFlowVOList = this.creditAccountFlowRepairRepoProc.selectListByParam(flowRepairPageParam);
        if (CollectionUtils.isEmpty(repairFlowVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u7b26\u5408\u91cd\u7b97\u7684\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e!");
        }
        List flowNoCheckList = repairFlowVOList.stream().filter(repairParam -> !StringUtils.isBlank((CharSequence)repairParam.getFlowNo())).map(CreditAccountFlowRepairVO::getFlowNo).collect(Collectors.toMap(e -> e, e -> 1, (a, b) -> a + b)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(flowNoCheckList)) {
            String checkResult = flowNoCheckList.stream().map(Objects::toString).collect(Collectors.joining("\u3001", "\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u53f7[", "], \u5b58\u5728\u91cd\u590d\u6570\u636e,\u8bf7\u68c0\u67e5!"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        List<String> repairFlowNoList = repairFlowVOList.stream().map(CreditAccountFlowRepairVO::getFlowNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(repairFlowNoList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u7b97\u7684\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e\u7684\u6d41\u6c34\u53f7\u4e3a\u7a7a!");
        }
        ArrayList repairFlowNoCacheList = new ArrayList();
        repairFlowNoList.forEach(flowNo -> {
            if (StringUtils.isNotBlank((CharSequence)this.getFlowNoCache((String)flowNo))) {
                repairFlowNoCacheList.add(flowNo);
            } else {
                this.saveFlowNoCache((String)flowNo);
            }
        });
        if (CollectionUtils.isNotEmpty(repairFlowNoCacheList)) {
            String checkResult = repairFlowNoCacheList.stream().map(Objects::toString).collect(Collectors.joining("\u3001", "\u8d26\u6237\u6d41\u6c34\u53f7[", "], \u4fee\u590d\u91cd\u7b97\u4e2d,\u8bf7\u7a0d\u540e\u518d\u6b21\u91cd\u7b97!"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        if (CollectionUtils.isNotEmpty(repairFlowVOList)) {
            this.processingCalculation(repairFlowVOList, repairFlowNoList);
        }
    }

    @Override
    public void removeFlowNoCacheBatch(List<String> flowNoList) {
        flowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
    }

    @Override
    public void removeFlowNoCache(String flowNo) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_ACCOUNT_FLOW_REPAIR_KEY_" + flowNo);
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    @Override
    public String getFlowNoCache(String flowNo) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_ACCOUNT_FLOW_REPAIR_KEY_" + flowNo);
        if (bucket.isExists()) {
            return (String)bucket.get();
        }
        return null;
    }

    @Override
    public void saveFlowNoCache(String flowNo) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_ACCOUNT_FLOW_REPAIR_KEY_" + flowNo);
        bucket.set((Object)flowNo);
    }

    private void processingCalculation(List<CreditAccountFlowRepairVO> repairFlowVOList, List<String> repairFlowNoList) {
        ArrayList accCodeList = new ArrayList();
        repairFlowVOList.forEach(flowRepairVO -> {
            CreditAccountFlowParam flowQueryParam = new CreditAccountFlowParam();
            flowQueryParam.setFlowNo(flowRepairVO.getFlowNo());
            log.info("\u4fee\u590d\u91cd\u7b97\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u67e5\u8be2\u6570\u636e,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)((Object)flowQueryParam)));
            List<CreditAccountFlowVO> flowVOList = this.creditAccountFlowService.selectListByQueryParam(flowQueryParam);
            log.info("\u4fee\u590d\u91cd\u7b97\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u67e5\u8be2\u6570\u636e,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowVOList));
            if (CollectionUtils.isNotEmpty(flowVOList) && flowVOList.size() == 1) {
                if (Objects.nonNull(flowVOList.get(0))) {
                    CreditAccountFlowVO flowVO = flowVOList.get(0);
                    if (Objects.equals(flowVO.getCreditAccountType(), UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode()) && FinConstant.CREDIT_ACCOUNT_FLOW_REPAIR_TRANSACTION_TYPE.contains(flowVO.getTransactionType())) {
                        this.repairFlow((CreditAccountFlowRepairVO)flowRepairVO, flowVO, accCodeList);
                    } else {
                        log.info("\u672a\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowVO));
                    }
                } else {
                    log.info("\u672a\u67e5\u8be2\u5230\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowRepairVO));
                }
            } else {
                log.info("\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e\u4e3a\u7a7a\u6216\u8005\u6709\u591a\u6761,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowVOList));
            }
        });
        if (CollectionUtils.isNotEmpty(accCodeList)) {
            List<String> accCodes = accCodeList.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
            this.updateAccountAmt(accCodes, repairFlowNoList);
        }
        repairFlowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void repairFlow(CreditAccountFlowRepairVO flowRepairVO, CreditAccountFlowVO flowVO, List<String> accCodeList) {
        this.repairCurrentFlow(flowRepairVO, flowVO, accCodeList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAccountAmt(List<String> accCodeList, List<String> repairFlowNoList) {
        accCodeList.forEach(accCode -> {
            CreditAccountFlowParam flowQueryParam = new CreditAccountFlowParam();
            flowQueryParam.setCreditAccountCode((String)accCode);
            CreditAccountFlowVO flowVO = this.creditAccountFlowRepoProc.selectPreviousRepairAmtByParam(flowQueryParam);
            CreditAccountDO accountDO = this.creditAccountRepoProc.findByCreditAccountCode((String)accCode);
            if (Objects.nonNull(flowVO) && Objects.nonNull((Object)accountDO)) {
                BigDecimal creditAccountLimit = flowVO.getCreditAccountLimit();
                BigDecimal creditAccountUsedLimit = flowVO.getCreditAccountUsedLimit();
                BigDecimal creditAccountOccupancyLimit = flowVO.getCreditAccountOccupancyLimit();
                BigDecimal creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
                accountDO.setCreditAccountLimit(creditAccountLimit);
                accountDO.setCreditAccountUsedLimit(creditAccountUsedLimit);
                accountDO.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
                accountDO.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
                this.creditAccountRepoProc.save((Serializable)((Object)accountDO));
            } else if (Objects.isNull((Object)accountDO)) {
                repairFlowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u4fe1\u7528\u8d26\u6237(" + accCode + ")\u4fe1\u606f!");
            }
        });
    }

    public void repairCurrentFlow(CreditAccountFlowRepairVO flowRepairVO, CreditAccountFlowVO flowVO, List<String> accCodeList) {
        CreditAccountFlowRepairHandleDTO flowRepairHandleDTO = this.assembleRepairHandle(flowRepairVO, flowVO);
        if (Objects.nonNull(flowRepairHandleDTO)) {
            this.repairCalculationFlow(flowRepairHandleDTO, accCodeList);
            this.creditAccountFlowRepairRepoProc.updateAmountAndRepairStatusById(flowRepairHandleDTO.getAmount(), UdcEnum.FLOW_REPAIR_STATUS_FIXED.getValueCode(), flowRepairHandleDTO.getFlowRepairId());
            this.repairAfterFlow(flowRepairVO, flowVO, flowRepairHandleDTO, accCodeList);
        }
    }

    public void repairAfterFlow(CreditAccountFlowRepairVO flowRepairVO, CreditAccountFlowVO flowVO, CreditAccountFlowRepairHandleDTO flowRepairCurrentHandleDTO, List<String> accCodeList) {
        List<CreditAccountFlowRepairHandleDTO> flowRepairHandleList = this.selectRepairAfterFlow(flowRepairVO, flowVO, flowRepairCurrentHandleDTO);
        if (CollectionUtils.isNotEmpty(flowRepairHandleList)) {
            flowRepairHandleList.forEach(flowRepairHandleDTO -> this.repairCalculationFlowAfter((CreditAccountFlowRepairHandleDTO)flowRepairHandleDTO, accCodeList));
        }
    }

    public List<CreditAccountFlowRepairHandleDTO> selectRepairAfterFlow(CreditAccountFlowRepairVO flowRepairVO, CreditAccountFlowVO flowVO, CreditAccountFlowRepairHandleDTO flowRepairCurrentHandleDTO) {
        List<CreditAccountFlowVO> flowAfterList;
        int size = 500;
        int page = 1;
        ArrayList<CreditAccountFlowRepairHandleDTO> flowRepairHandleList = new ArrayList<CreditAccountFlowRepairHandleDTO>();
        CreditAccountFlowParam flowPageParam = new CreditAccountFlowParam();
        flowPageParam.setCreditAccountCode(flowVO.getCreditAccountCode());
        flowPageParam.setRepairTime(flowVO.getCreateTime());
        do {
            flowPageParam.setCurrent(page++);
            flowPageParam.setSize(size);
            log.info("\u67e5\u8be2\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u53ca\u4e4b\u540e\u6d41\u6c34,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)((Object)flowPageParam)));
            flowAfterList = this.creditAccountFlowService.selectRepairAfterPage(flowPageParam);
            log.info("\u67e5\u8be2\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u53ca\u4e4b\u540e\u6d41\u6c34,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowAfterList));
            if (CollectionUtils.isEmpty(flowAfterList)) break;
            flowAfterList.forEach(flowAfterVO -> {
                CreditAccountFlowRepairHandleDTO flowRepairHandleDTO = this.assembleRepairAfterHandle(flowRepairVO, (CreditAccountFlowVO)flowAfterVO, flowRepairCurrentHandleDTO);
                if (Objects.nonNull(flowRepairHandleDTO)) {
                    flowRepairHandleList.add(flowRepairHandleDTO);
                } else {
                    log.info("\u6309\u7167\u4ea4\u6613\u7c7b\u578b\u672a\u5339\u914d\u5230\u4fe1\u7528\u8d26\u6237\u6d41\u6c34,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowAfterList));
                }
            });
        } while (flowAfterList.size() >= size);
        return flowRepairHandleList;
    }

    private CreditAccountFlowRepairHandleDTO assembleRepairHandle(CreditAccountFlowRepairVO flowRepairVO, CreditAccountFlowVO flowVO) {
        if (Objects.isNull(flowRepairVO.getActualAmount()) || Objects.isNull(flowVO.getCreditAccountLimit()) || Objects.isNull(flowVO.getCreditAccountOccupancyLimit()) || Objects.isNull(flowVO.getCreditAccountUsedLimit()) || Objects.isNull(flowVO.getAmount())) {
            log.info("\u672a\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowVO));
            return null;
        }
        CreditAccountFlowRepairHandleDTO flowRepairHandleDTO = new CreditAccountFlowRepairHandleDTO();
        flowRepairHandleDTO.setFlowRepairId(flowRepairVO.getId());
        flowRepairHandleDTO.setFlowRepairFlowNo(flowRepairVO.getFlowNo());
        flowRepairHandleDTO.setFlowId(flowVO.getId());
        flowRepairHandleDTO.setFlowNo(flowVO.getFlowNo());
        flowRepairHandleDTO.setActualAmount(flowRepairVO.getActualAmount());
        flowRepairHandleDTO.setAmount(flowVO.getAmount());
        BigDecimal variableAmount = flowRepairVO.getActualAmount().subtract(flowVO.getAmount());
        flowRepairHandleDTO.setVariableAmount(variableAmount);
        flowRepairHandleDTO.setAccountType(flowVO.getCreditAccountType());
        flowRepairHandleDTO.setAccountCode(flowVO.getCreditAccountCode());
        flowRepairHandleDTO.setAccountName(flowVO.getCreditAccountName());
        flowRepairHandleDTO.setTransactionType(flowVO.getTransactionType());
        flowRepairHandleDTO.setCreditAccountLimit(flowVO.getCreditAccountLimit());
        flowRepairHandleDTO.setCreditAccountOccupancyLimit(flowVO.getCreditAccountOccupancyLimit());
        flowRepairHandleDTO.setCreditAccountUsedLimit(flowVO.getCreditAccountUsedLimit());
        flowRepairHandleDTO.setCreditAccountAvailableLimit(flowVO.getCreditAccountAvailableLimit());
        return flowRepairHandleDTO;
    }

    private CreditAccountFlowRepairHandleDTO assembleRepairAfterHandle(CreditAccountFlowRepairVO flowRepairVO, CreditAccountFlowVO flowVO, CreditAccountFlowRepairHandleDTO flowRepairCurrentHandleDTO) {
        if (Objects.isNull(flowRepairVO.getActualAmount()) || Objects.isNull(flowVO.getCreditAccountLimit()) || Objects.isNull(flowVO.getCreditAccountOccupancyLimit()) || Objects.isNull(flowVO.getCreditAccountUsedLimit()) || Objects.isNull(flowVO.getAmount())) {
            log.info("\u672a\u4fee\u590d\u4fe1\u7528\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowVO));
            return null;
        }
        CreditAccountFlowRepairHandleDTO flowRepairHandleDTO = new CreditAccountFlowRepairHandleDTO();
        flowRepairHandleDTO.setFlowRepairId(flowRepairVO.getId());
        flowRepairHandleDTO.setFlowRepairFlowNo(flowRepairVO.getFlowNo());
        flowRepairHandleDTO.setFlowId(flowVO.getId());
        flowRepairHandleDTO.setFlowNo(flowVO.getFlowNo());
        flowRepairHandleDTO.setActualAmount(flowRepairVO.getActualAmount());
        flowRepairHandleDTO.setAmount(flowVO.getAmount());
        BigDecimal variableAmount = flowRepairCurrentHandleDTO.getVariableAmount();
        flowRepairHandleDTO.setVariableAmount(variableAmount);
        flowRepairHandleDTO.setAccountType(flowVO.getCreditAccountType());
        flowRepairHandleDTO.setAccountCode(flowVO.getCreditAccountCode());
        flowRepairHandleDTO.setAccountName(flowVO.getCreditAccountName());
        flowRepairHandleDTO.setTransactionType(flowRepairCurrentHandleDTO.getTransactionType());
        flowRepairHandleDTO.setCreditAccountLimit(flowVO.getCreditAccountLimit());
        flowRepairHandleDTO.setCreditAccountOccupancyLimit(flowVO.getCreditAccountOccupancyLimit());
        flowRepairHandleDTO.setCreditAccountUsedLimit(flowVO.getCreditAccountUsedLimit());
        flowRepairHandleDTO.setCreditAccountAvailableLimit(flowVO.getCreditAccountAvailableLimit());
        return flowRepairHandleDTO;
    }

    public void repairCalculationFlow(CreditAccountFlowRepairHandleDTO flowRepairHandleDTO, List<String> accCodeList) {
        BigDecimal creditAccountLimit = flowRepairHandleDTO.getCreditAccountLimit();
        BigDecimal creditAccountOccupancyLimit = flowRepairHandleDTO.getCreditAccountOccupancyLimit();
        BigDecimal creditAccountUsedLimit = flowRepairHandleDTO.getCreditAccountUsedLimit();
        BigDecimal creditAccountAvailableLimit = BigDecimal.ZERO;
        BigDecimal variableAmount = flowRepairHandleDTO.getVariableAmount();
        BigDecimal actualAmount = flowRepairHandleDTO.getActualAmount();
        if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_R.getValueCode())) {
            creditAccountOccupancyLimit = creditAccountOccupancyLimit.subtract(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateOccupancyAndAvailableAndAmountById(creditAccountOccupancyLimit, creditAccountAvailableLimit, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_T.getValueCode())) {
            creditAccountOccupancyLimit = creditAccountOccupancyLimit.add(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateOccupancyAndAvailableAndAmountById(creditAccountOccupancyLimit, creditAccountAvailableLimit, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_O.getValueCode())) {
            creditAccountLimit = creditAccountLimit.subtract(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateAccountAndAvailableAndAmountById(creditAccountLimit, creditAccountAvailableLimit, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_I.getValueCode())) {
            creditAccountLimit = creditAccountLimit.add(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateAccountAndAvailableAndAmountById(creditAccountLimit, creditAccountAvailableLimit, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_U.getValueCode())) {
            creditAccountUsedLimit = creditAccountUsedLimit.add(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateUsedAndAvailableAndAmountById(creditAccountUsedLimit, creditAccountAvailableLimit, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_D.getValueCode())) {
            creditAccountUsedLimit = creditAccountUsedLimit.subtract(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateUsedAndAvailableAndAmountById(creditAccountUsedLimit, creditAccountAvailableLimit, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        }
    }

    public void repairCalculationFlowAfter(CreditAccountFlowRepairHandleDTO flowRepairHandleDTO, List<String> accCodeList) {
        BigDecimal creditAccountLimit = flowRepairHandleDTO.getCreditAccountLimit();
        BigDecimal creditAccountOccupancyLimit = flowRepairHandleDTO.getCreditAccountOccupancyLimit();
        BigDecimal creditAccountUsedLimit = flowRepairHandleDTO.getCreditAccountUsedLimit();
        BigDecimal creditAccountAvailableLimit = BigDecimal.ZERO;
        BigDecimal variableAmount = flowRepairHandleDTO.getVariableAmount();
        if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_R.getValueCode())) {
            creditAccountOccupancyLimit = creditAccountOccupancyLimit.subtract(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateOccupancyAndAvailableById(creditAccountOccupancyLimit, creditAccountAvailableLimit, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_T.getValueCode())) {
            creditAccountOccupancyLimit = creditAccountOccupancyLimit.add(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateOccupancyAndAvailableById(creditAccountOccupancyLimit, creditAccountAvailableLimit, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_O.getValueCode())) {
            creditAccountLimit = creditAccountLimit.subtract(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateAccountAndAvailableById(creditAccountLimit, creditAccountAvailableLimit, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_I.getValueCode())) {
            creditAccountLimit = creditAccountLimit.add(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateAccountAndAvailableById(creditAccountLimit, creditAccountAvailableLimit, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_U.getValueCode())) {
            creditAccountUsedLimit = creditAccountUsedLimit.add(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateUsedAndAvailableById(creditAccountUsedLimit, creditAccountAvailableLimit, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.CREDIT_IO_TYPE_D.getValueCode())) {
            creditAccountUsedLimit = creditAccountUsedLimit.subtract(variableAmount);
            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);
            this.creditAccountFlowRepoProc.updateUsedAndAvailableById(creditAccountUsedLimit, creditAccountAvailableLimit, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        }
    }

    public CreditAccountFlowRepairServiceImpl(CreditAccountFlowRepairRepo creditAccountFlowRepairRepo, CreditAccountFlowRepairRepoProc creditAccountFlowRepairRepoProc, CreditAccountFlowService creditAccountFlowService, CreditAccountFlowRepoProc creditAccountFlowRepoProc, CreditAccountRepoProc creditAccountRepoProc, RedissonClient redissonClient) {
        this.creditAccountFlowRepairRepo = creditAccountFlowRepairRepo;
        this.creditAccountFlowRepairRepoProc = creditAccountFlowRepairRepoProc;
        this.creditAccountFlowService = creditAccountFlowService;
        this.creditAccountFlowRepoProc = creditAccountFlowRepoProc;
        this.creditAccountRepoProc = creditAccountRepoProc;
        this.redissonClient = redissonClient;
    }
}

