package com.elitesland.fin.application.facade.dto.invoice;


import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class InvoiceAwaitDTO implements Serializable {

    private static final long serialVersionUID = 261771874479453725L;

    @ApiModelProperty("表头ID")
    private Long id;

    @ApiModelProperty("待开发票单号")
    private String docNo;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户ID")
    private Long custId;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户姓名")
    private String custName;

    @ApiModelProperty("金额")
    private BigDecimal amt;

    @ApiModelProperty("待开发票状态")
    @SysCode(sys = "yst-fin", mod = "INVOICE_AWAIT_STATUS")
    private String invoiceAwaitStatus;
    private String invoiceAwaitStatusName;

    @ApiModelProperty("来源单据名称")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String optDocCls;
    private String optDocClsName;

    @ApiModelProperty("来源单据")
    @SysCode(sys = "yst-supp", mod = "DOC_TYPE")
    private String optDocType;
    private String optDocTypeName;

    @ApiModelProperty("来源单号")
    private String optDocNo;

    @ApiModelProperty("来源单据状态")
    @SysCode(sys = "yst-supp", mod = "DOC_STATUS")
    private String optDocStatus;
    private String optDocStatusName;

    @ApiModelProperty("发票文件编码")
    private String invoiceFileCode;

    @ApiModelProperty("开票申请单号")
    private String invoiceApplyNo;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("发票类型")
    @SysCode(sys = "yst-supp", mod = "INV_TYPE")
    private String invoiceType;
    private String invoiceTypeName;

    @ApiModelProperty("来源单据主键id")
    private Long optDocId;

    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    @ApiModelProperty("币种")
    private String currCode;

    /**
     * 确认时间
     */
    @ApiModelProperty("确认时间")
    private LocalDateTime confirmTime;

    @ApiModelProperty("主客户编码")
    private String mainCustCode;

    @ApiModelProperty("主客户名称")
    private String mainCustName;

    @ApiModelProperty("主客户id")
    private Long mainCustId;

    @ApiModelProperty("待开发票详情")
    private List<InvoiceAwaitDDTO> invoiceAwaitDDTOList;

    @ApiModelProperty("集团编码")
    private String pkGroup;

    @ApiModelProperty("开票类型编码")
    private String openInvType;

    @ApiModelProperty("结算方式")
    private String settlementType;

    @ApiModelProperty(value = "是否允许修改发票抬头 1-是 0-否")
    private Integer editInvTitle;

    @ApiModelProperty("合同开始时间")
    private String es1;

    @ApiModelProperty("是否是通用客商 1-是 0-不是")
    private String es3;

    @ApiModelProperty("对账类型/订单分组")
    @SysCode(sys = "yst-order",mod = "ORDER_TYPE3")
    private String docType3;
    private String docType3Name;

    /**
     * 订货人
     */
    @ApiModelProperty("订货人")
    private String recvContactName;
    /**
     * 订货联系电话
     */
    @ApiModelProperty("订货联系电话")
    private String recvContactTel;
}
