package com.elitesland.fin.application.facade.param.account;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 账户表;
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 */
@Data
@ApiModel(description = "账户快照查询参数")
public class AccountSnapshotParam extends BaseModelParam {

    @ApiModelProperty("开户主体名称")
    private String accountHolderName;

    @ApiModelProperty("开户主体编码")
    private String accountHolderCode;

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户名称")
    private String accountName;

    @ApiModelProperty("账户类型")
    private String accountType;

    @ApiModelProperty("快照开始时间")
    private LocalDateTime snapshotStartTime;

    @ApiModelProperty("快照结束时间")
    private LocalDateTime snapshotEndTime;

}
