package com.elitesland.fin.application.facade.param.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "事件表单")
public class FinEventTableParam extends BaseModelParam {

    @ApiModelProperty("事件表单名称")
    private String eventTable;

    @ApiModelProperty("主机")
    private String host;

    @ApiModelProperty("端口")
    private String port;

    @ApiModelProperty("用户名")
    private String user;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("数据库名称")
    private String database;

    @ApiModelProperty("主表")
    private String masTable;

    @ApiModelProperty("子表")
    private String table;

    @ApiModelProperty("主表条件字段")
    private String masTableColumn;

    @ApiModelProperty("子表条件字段")
    private String tableColumn;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("事件表单条件")
    private List<FinEventTableConditionParam> finEventTableConditionDetailList;

    @ApiModelProperty("事件表单明细")
    private List<FinEventTableLineParam> finEventTableLineDetailList;
}
