package com.elitesland.fin.application.facade.param.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "值集")
public class FinFlexibleValueParam extends BaseModelParam {

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("序号")
    private Integer serialNum;

    @ApiModelProperty("值")
    private String flexibleValueCode;

    @ApiModelProperty("值名称")
    private String flexibleValueName;

    @ApiModelProperty("是否有子代")
    private Boolean descendantsFlag;

    @ApiModelProperty("是否启用")
    private Boolean activeFlag;

    @ApiModelProperty("是否记账")
    private Boolean accountFlag;

    @ApiModelProperty("主值")
    private String masFlexibleValueCode;

    @ApiModelProperty("主值名称")
    private String masFlexibleValueName;

    @ApiModelProperty("起始有效日期")
    private LocalDateTime activeStartTime;

    @ApiModelProperty("终止有效日期")
    private LocalDateTime activeEndTime;

    @ApiModelProperty("上级值")
    private String parentFlexibleValueCode;

    @ApiModelProperty("上级值名称")
    private String parentFlexibleValueName;
}
