package com.elitesland.fin.application.facade.param.accountreport;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 账户表;
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 */
@Data
@ApiModel(description = "账户报表")
public class AccountReportPageParam extends BaseModelParam {

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("未汇款金额")
    private BigDecimal unremittedAmountStart;

    @ApiModelProperty("未汇款金额")
    private BigDecimal unremittedAmountEnd;

    @ApiModelProperty("信用账户额度")
    private BigDecimal creditAccountLimitStart;

    @ApiModelProperty("信用账户额度")
    private BigDecimal creditAccountLimitEnd;
}