package com.elitesland.fin.application.facade.param.adjustorder;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/2/25 10:47
 */
@Data
@ApiModel(description = "调整单")
public class AdjustOrderPageParam extends BaseModelParam {
    private static final long serialVersionUID = 8208667701295973631L;

    @ApiModelProperty
    private List<Long> ids;

    @ApiModelProperty("调整单号")
    private String docNo;

    @ApiModelProperty("状态")
    private List<String> state;

    @ApiModelProperty("单据类型")
    private String type;

    @ApiModelProperty("记账时间")
    private LocalDateTime recAccTime;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户主体名称")
    private String accountHolderName;

    @ApiModelProperty("开户主体编码")
    private String accountHolderCode;

    @ApiModelProperty("总金额从")
    private BigDecimal totalAmtF;

    @ApiModelProperty("总金额至")
    private BigDecimal totalAmtT;

    @ApiModelProperty("账户类型")
    private String accType;

    @ApiModelProperty("审核时间起始")
    private LocalDateTime auditTimeS;

    @ApiModelProperty("审核时间截至")
    private LocalDateTime auditTimeE;

    @ApiModelProperty("调整类型")
    private List<String> adjType;

    @ApiModelProperty("调整原因")
    private List<String> adjReason;

    @ApiModelProperty("创建时间起始")
    private LocalDateTime createTimeS;

    @ApiModelProperty("创建时间截至")
    private LocalDateTime createTimeE;

    @ApiModelProperty("加盟商编码")
    private String secFranchiseeCode;

    @ApiModelProperty("加盟商名称")
    private String secFranchiseeName;
}
