package com.elitesland.fin.application.facade.vo.creditaccount;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 账户表;
 *
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 */
@ApiModel(value = "信用账户分页查询返回结果")
@Data
public class CreditAccountPageVO extends BaseModelVO {

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("对象类型(客户组 客户)")
    @SysCode(sys = "yst-fin", mod = "OBJECT_TYPE")
    private String objectType;
    private String objectTypeName;

    @ApiModelProperty("对象名称(客户组名称/客户名称)")
    private String objectName;

    @ApiModelProperty("信用账户编码")
    private String creditAccountCode;

    @ApiModelProperty("信用账户名称")
    private String creditAccountName;

    @ApiModelProperty("信用账户类型")
    @SysCode(sys = "yst-fin", mod = "CREDIT_ACCOUNT_TYPE")
    private String creditAccountType;
    private String creditAccountTypeName;

    @ApiModelProperty("对象编码")
    private String objectCode;

    @ApiModelProperty("部门ID")
    private Long deptId;

    @ApiModelProperty("部门编码")
    private String deptCode;

    @ApiModelProperty("部门名称")
    private String deptName;

    @ApiModelProperty("产品线编码")
    private String productLineCode;

    @ApiModelProperty("产品线名称")
    private String productLineName;

    @ApiModelProperty("业务员编号")
    private String salesmanNo;

    @ApiModelProperty("业务员姓名")
    private String salesmanName;

    @ApiModelProperty("信用账户额度")
    private BigDecimal creditAccountLimit;

    @ApiModelProperty("信用账户占用额度")
    private BigDecimal creditAccountOccupancyLimit;

    @ApiModelProperty("信用账户使用额度")
    private BigDecimal creditAccountUsedLimit;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty("信用账户可用额度")
    private BigDecimal creditAccountAvailableLimit;

//    public BigDecimal getCreditAccountAvailableLimit() {
//        return NumberUtil.sub(creditAccountLimit, creditAccountUsedLimit, creditAccountOccupancyLimit).setScale(8, RoundingMode.HALF_UP);
//    }
}