package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleConvert;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleValueConvert;
import com.elitesland.fin.application.convert.accountingengine.FinJournalConvert;
import com.elitesland.fin.application.facade.param.accountingengine.FinJournalParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleValueParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinJournalVO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.repo.accountingengine.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class FinJournalServiceImpl implements FinJournalService {


    private final FinJournalRepo finJournalRepo;

    private final FinJournalRepoProc finJournalRepoProc;



    @SysCodeProc
    @Override
    public PagingVO<FinJournalVO> page(FinJournalParam finJournalParam) {
        return FinJournalConvert.INSTANCE.DTOToVO(finJournalRepoProc.page(finJournalParam));
    }

}
