package com.elitesland.fin.application.service.accountreport;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.AccountConvert;
import com.elitesland.fin.application.convert.accountreport.AccountReportConvert;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.accountreport.AccountReportPageParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountPageParam;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.facade.vo.accountreport.AccountReportVO;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountPageVO;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.entity.account.QAccountDO;
import com.elitesland.fin.entity.account.QAccountRuleConfigDO;
import com.elitesland.fin.entity.account.QAccountRuleConfigDtlDO;
import com.elitesland.fin.entity.creditaccount.CreditAccountDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.account.AccountStorageRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.utils.StringUtil;
import com.elitesland.fin.utils.SysUtils;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.models.auth.In;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Service
@RequiredArgsConstructor
public class AccountReportServiceImpl implements AccountReportService {


    private final AccountRepoProc accountRepoProc;

    private final CreditAccountRepoProc creditAccountRepoProc;


    private BigDecimal setScale(BigDecimal bigDecimal, Integer amtRound) {
        return bigDecimal.setScale(amtRound, RoundingMode.HALF_UP);
    }

    @Override
    public PagingVO<AccountReportVO> page(AccountReportPageParam accountReportPageParam) {

        //查询信用账户列表
        CreditAccountPageParam creditAccountPageParam = new CreditAccountPageParam();
        creditAccountPageParam.setOuCode(accountReportPageParam.getOuCode());
        creditAccountPageParam.setObjectCode(accountReportPageParam.getCustCode());
        creditAccountPageParam.setCreditAccountLimitStart(accountReportPageParam.getCreditAccountLimitStart());
        creditAccountPageParam.setCreditAccountLimitEnd(accountReportPageParam.getCreditAccountLimitEnd());
        creditAccountPageParam.setIds(accountReportPageParam.getIds());

        List<CreditAccountPageVO> creditAccountPageVOList = creditAccountRepoProc.queryList(creditAccountPageParam);

        //查询账户列表
        AccountPageParam accountPageParam = new AccountPageParam();
        accountPageParam.setSecOuCode(accountReportPageParam.getOuCode());
        accountPageParam.setAccountHolderCode(accountReportPageParam.getCustCode());

        List<AccountVO> accountVOList = accountRepoProc.queryList(accountPageParam);

        Map<String, AccountVO> accountVOMap = accountVOList.stream().collect(Collectors.toMap(item -> {
            if (UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType())) {
                return item.getSecOuCode() + item.getAccountHolderCode() + UdcEnum.ACCOUNT_TYPE_STORE.getValueCode();
            }
            if (UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType())) {
                return item.getSecOuCode() + item.getAccountHolderCode() + UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode();
            }
            return null;
        }, item -> item));

        Integer amtRound = SysUtils.getAmtPlace();
        //组装对象金额
        Map<Long, AccountReportVO> accountReportVOMap = creditAccountPageVOList.stream().map(item -> {

            AccountReportVO accountReportVO = new AccountReportVO();

            accountReportVO.setId(item.getId());
            accountReportVO.setOuCode(item.getOuCode());
            accountReportVO.setOuName(item.getOuName());
            accountReportVO.setCustCode(item.getObjectCode());
            accountReportVO.setCustName(item.getObjectName());
            accountReportVO.setCreditAccountLimit(setScale(nullDefaultZero(item.getCreditAccountLimit()), amtRound));
            accountReportVO.setCreditAccountUsedLimit(setScale(nullDefaultZero(item.getCreditAccountUsedLimit()), amtRound));
            accountReportVO.setCreditAccountOccupancyLimit(setScale(nullDefaultZero(item.getCreditAccountOccupancyLimit()), amtRound));
            accountReportVO.setCreditAccountAvailableLimit(setScale(nullDefaultZero(item.getCreditAccountAvailableLimit()), amtRound));

            String uniqueKey = item.getOuCode() + item.getObjectCode();

            AccountVO accountVO = accountVOMap.get(uniqueKey + UdcEnum.ACCOUNT_TYPE_STORE.getValueCode());
            accountReportVO.setStorageAccountAmount(setScale(accountVO.getAccountAmount(), amtRound));
            accountReportVO.setStorageAccountOccupancyAmount(setScale(accountVO.getAccountOccupancyAmount(), amtRound));
            accountReportVO.setStorageAccountAvailableAmount(setScale(accountVO.getAccountAvailableAmount(), amtRound));


            accountVO = accountVOMap.get(uniqueKey + UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode());
            accountReportVO.setRebateAccountAmount(setScale(accountVO.getAccountAmount(), amtRound));
            accountReportVO.setRebateAccountOccupancyAmount(setScale(accountVO.getAccountOccupancyAmount(), amtRound));
            accountReportVO.setRebateAccountAvailableAmount(setScale(accountVO.getAccountAvailableAmount(), amtRound));

            calculateAmount(accountReportVO, amtRound);

            BigDecimal unremittedAmountStart = accountReportPageParam.getUnremittedAmountStart();
            if (unremittedAmountStart != null) {
                if (accountReportVO.getUnremittedAmount().compareTo(unremittedAmountStart) < 0) {
                    return null;
                }
            }

            BigDecimal unremittedAmountEnd = accountReportPageParam.getUnremittedAmountEnd();
            if (unremittedAmountEnd != null) {
                if (accountReportVO.getUnremittedAmount().compareTo(unremittedAmountEnd) > 0) {
                    return null;
                }
            }

            return accountReportVO;
        }).filter(Objects::nonNull).collect(Collectors.toMap(AccountReportVO::getId, item -> item));

        if (accountReportVOMap.size() == 0) {
            return PagingVO.<AccountReportVO>builder()
                    .total(0)
                    .records(Lists.newArrayList())
                    .build();
        }

        creditAccountPageParam = AccountReportConvert.INSTANCE.param2Param(accountReportPageParam);
        creditAccountPageParam.setCurrent(accountReportPageParam.current);
        creditAccountPageParam.setIds(Lists.newArrayList(accountReportVOMap.keySet()));
        PagingVO<CreditAccountPageVO> creditAccountPageVOPagingVO = creditAccountRepoProc.search(creditAccountPageParam);

        List<AccountReportVO> accountReportVOList = creditAccountPageVOPagingVO.getRecords().stream()
                .map(item -> accountReportVOMap.get(item.getId())).collect(Collectors.toList());

        return PagingVO.<AccountReportVO>builder()
                .total(accountReportVOMap.size())
                .records(accountReportVOList)
                .build();
    }

    private void calculateAmount(AccountReportVO accountReportVO, Integer amtRound) {

        accountReportVO.setAvailableAmount(setScale(accountReportVO.getStorageAccountAvailableAmount()
                .add(accountReportVO.getRebateAccountAvailableAmount())
                .add(accountReportVO.getCreditAccountAvailableLimit()), amtRound));

        BigDecimal unremittedAmount = accountReportVO.getCreditAccountUsedLimit()
                .add(accountReportVO.getCreditAccountOccupancyLimit())
                .subtract(accountReportVO.getStorageAccountAvailableAmount());
        accountReportVO.setUnremittedAmount(unremittedAmount.compareTo(BigDecimal.ZERO) > 0 ? unremittedAmount : BigDecimal.ZERO);
        accountReportVO.setUnremittedAmount(setScale(accountReportVO.getUnremittedAmount(), amtRound));
    }

    private BigDecimal nullDefaultZero(BigDecimal bigDecimal) {
        return Optional.ofNullable(bigDecimal).orElse(BigDecimal.ZERO);
    }
}
