package com.elitesland.fin.application.service.excel.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.fin.utils.ExcelUtil;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "信用账户", description = "信用账户")
@Data
public class CreditAccountExportEntity implements Serializable {

    @ExcelProperty(value = "授信组织", index = 0)
    private String ouName;

    @ExcelProperty(value = "对象类型", index = 1)
    private String objectTypeName;

    @ExcelProperty(value = "对象名称", index = 2)
    private String objectName;

    @ExcelProperty(value = "对象编码", index = 3)
    private String objectCode;

    @ExcelProperty(value = "部门", index = 4)
    private String deptName;

    @ExcelProperty(value = "产品线", index = 5)
    private String productLineName;

    @ExcelProperty(value = "业务员", index = 6)
    private String salesmanName;

    @ExcelProperty(value = "账户编码", index = 7)
    private String creditAccountCode;

    @ExcelProperty(value = "账户名称", index = 8)
    private String creditAccountName;

    @ExcelProperty(value = "账户类型", index = 9)
    private String creditAccountTypeName;

    @ExcelProperty(value = "账户额度", index = 10)
    private BigDecimal creditAccountLimit;

    @ExcelProperty(value = "账户使用额度", index = 11)
    private BigDecimal creditAccountUsedLimit;

    @ExcelProperty(value = "账户占用额度", index = 12)
    private BigDecimal creditAccountOccupancyLimit;

    @ExcelProperty(value = "账户可用额度", index = 13)
    private BigDecimal creditAccountAvailableLimit;

    @ExcelProperty(value = "状态", index = 14)
    private String statusName;

    @ExcelProperty(value = "创建人", index = 15)
    private String creator;

    @ExcelProperty(value = "创建时间", index = 16)
    private LocalDateTime createTime;

    @ExcelProperty(value = "备注", index = 17)
    private String remark;


    public String getCreditAccountLimit() {
        return ExcelUtil.twoPointNum(creditAccountLimit);
    }


    public String getCreditAccountAvailableLimit() {
        return ExcelUtil.twoPointNum(creditAccountAvailableLimit);
    }

    public String getCreditAccountOccupancyLimit() {
        return ExcelUtil.twoPointNum(creditAccountOccupancyLimit);
    }

    public String getCreditAccountUsedLimit() {
        return ExcelUtil.twoPointNum(creditAccountUsedLimit);
    }
}
