package com.elitesland.fin.application.service.excel.exp;


import cn.hutool.core.lang.Assert;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.account.AccountConvert;
import com.elitesland.fin.application.convert.accountreport.AccountReportConvert;
import com.elitesland.fin.application.facade.excel.convert.BigDecimalConvert;
import com.elitesland.fin.application.facade.param.account.AccountSnapshotParam;
import com.elitesland.fin.application.facade.param.accountreport.AccountReportPageParam;
import com.elitesland.fin.application.facade.vo.account.AccountSnapshotVo;
import com.elitesland.fin.application.facade.vo.accountreport.AccountReportVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.accountreport.AccountReportService;
import com.elitesland.fin.application.service.excel.entity.AccountReportExportEntity;
import com.elitesland.fin.application.service.excel.entity.AccountSnapshotExportEntity;
import com.elitesland.fin.application.service.excel.entity.CreditAccountSnapshotExportEntity;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.checkerframework.checker.units.qual.A;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 账户报表导出
 *
 * @author : gyj
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class AccountReportExportServiceImpl implements DataExport<AccountReportExportEntity, AccountReportPageParam> {

    private final AccountReportService accountReportService;

    static final ThreadLocal<BigDecimal> availableAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> unremittedAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> creditAccountLimit = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> creditAccountUsedLimit = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> creditAccountOccupancyLimit = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> creditAccountAvailableLimit = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> storageAccountAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> storageAccountOccupancyAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> storageAccountAvailableAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> rebateAccountAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> rebateAccountOccupancyAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);
    static final ThreadLocal<BigDecimal> rebateAccountAvailableAmount = ThreadLocal.withInitial(() -> BigDecimal.ZERO);


    @Override
    public String getTmplCode() {
        return "fin_account_report_export";
    }

    public PagingVO<AccountReportExportEntity> executeExport(AccountReportPageParam queryParam) {

        PagingVO<AccountReportVO> page = accountReportService.page(queryParam);

        PagingVO<AccountReportExportEntity> accountReportExportEntityPagingVO = AccountReportConvert.INSTANCE.VO2ExportEntity(page);

        List<AccountReportExportEntity> records = accountReportExportEntityPagingVO.getRecords();

        if (CollectionUtils.isEmpty(records)) {
            return accountReportExportEntityPagingVO;
        }

        for (AccountReportExportEntity item : records) {
            availableAmount.set(availableAmount.get().add(item.getAvailableAmount()));
            unremittedAmount.set(unremittedAmount.get().add(item.getUnremittedAmount()));
            creditAccountLimit.set(creditAccountLimit.get().add(item.getCreditAccountLimit()));
            creditAccountUsedLimit.set(creditAccountUsedLimit.get().add(item.getCreditAccountUsedLimit()));
            creditAccountOccupancyLimit.set(creditAccountOccupancyLimit.get().add(item.getCreditAccountOccupancyLimit()));
            creditAccountAvailableLimit.set(creditAccountAvailableLimit.get().add(item.getCreditAccountAvailableLimit()));
            storageAccountAmount.set(storageAccountAmount.get().add(item.getStorageAccountAmount()));
            storageAccountOccupancyAmount.set(storageAccountOccupancyAmount.get().add(item.getStorageAccountOccupancyAmount()));
            storageAccountAvailableAmount.set(storageAccountAvailableAmount.get().add(item.getStorageAccountAvailableAmount()));
            rebateAccountAmount.set(rebateAccountAmount.get().add(item.getRebateAccountAmount()));
            rebateAccountOccupancyAmount.set(rebateAccountOccupancyAmount.get().add(item.getRebateAccountOccupancyAmount()));
            rebateAccountAvailableAmount.set(rebateAccountAvailableAmount.get().add(item.getRebateAccountAvailableAmount()));
        }

        if (queryParam.getCurrent() * queryParam.getSize() + accountReportExportEntityPagingVO.getRecords().size() ==
                accountReportExportEntityPagingVO.getTotal()) {
            AccountReportExportEntity accountReportExportEntity = new AccountReportExportEntity();
            accountReportExportEntity.setAvailableAmount(availableAmount.get());
            accountReportExportEntity.setUnremittedAmount(unremittedAmount.get());
            accountReportExportEntity.setCreditAccountLimit(creditAccountLimit.get());
            accountReportExportEntity.setCreditAccountUsedLimit(creditAccountUsedLimit.get());
            accountReportExportEntity.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit.get());
            accountReportExportEntity.setCreditAccountAvailableLimit(creditAccountAvailableLimit.get());
            accountReportExportEntity.setStorageAccountAmount(storageAccountAmount.get());
            accountReportExportEntity.setStorageAccountOccupancyAmount(storageAccountOccupancyAmount.get());
            accountReportExportEntity.setStorageAccountAvailableAmount(storageAccountAvailableAmount.get());
            accountReportExportEntity.setRebateAccountAmount(rebateAccountAmount.get());
            accountReportExportEntity.setRebateAccountOccupancyAmount(rebateAccountOccupancyAmount.get());
            accountReportExportEntity.setRebateAccountAvailableAmount(rebateAccountAvailableAmount.get());

            records.add(accountReportExportEntity);
            accountReportExportEntityPagingVO.setTotal(accountReportExportEntityPagingVO.getTotal() + 1);

            availableAmount.remove();
            unremittedAmount.remove();
            creditAccountLimit.remove();
            creditAccountUsedLimit.remove();
            creditAccountOccupancyLimit.remove();
            creditAccountAvailableLimit.remove();
            storageAccountAmount.remove();
            storageAccountOccupancyAmount.remove();
            storageAccountAvailableAmount.remove();
            rebateAccountAmount.remove();
            rebateAccountOccupancyAmount.remove();
            rebateAccountAvailableAmount.remove();
        }
        return accountReportExportEntityPagingVO;
    }
}
