package com.elitesland.fin.application.web.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountEngineDetailsParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountEngineParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccEngDetDataLineVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccountEngineDetailsVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccountEngineVO;
import com.elitesland.fin.application.service.accountingengine.FinAccountEngineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * @author gyj
 * @date 2023/10/10
 */
@RestController
@RequestMapping("/account/engine")
@RequiredArgsConstructor
@Api(value = "会计引擎", tags = {"会计引擎"})
public class FinAccountEngineController {

    private final FinAccountEngineService finAccountEngineService;

    @PostMapping("/saveOrUpdate")
    @ApiOperation("新增/修改")
    public ApiResult<Long> saveOrUpdate(@RequestBody FinAccountEngineParam finAccountEngineParam) {
        return ApiResult.ok(finAccountEngineService.saveOrUpdate(finAccountEngineParam));
    }

    @PostMapping("/saveOrUpdateFinAccountEngineDetails")
    @ApiOperation("新增/修改")
    public ApiResult<Long> saveOrUpdateFinAccountEngineDetails(@RequestBody FinAccountEngineDetailsParam param) {
        return ApiResult.ok(finAccountEngineService.saveOrUpdateFinAccountEngineDetails(param));
    }


    @PostMapping("/page")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<FinAccountEngineVO>> page(@RequestBody FinAccountEngineParam finAccountEngineParam) {
        return ApiResult.ok(finAccountEngineService.page(finAccountEngineParam));
    }

    @PostMapping("/accountEngine")
    @ApiOperation("详情查询")
    public ApiResult<FinAccountEngineVO> queryFinAccountEngine(@RequestBody FinAccountEngineDetailsParam param) {
        return ApiResult.ok(finAccountEngineService.queryFinAccountEngine(param));
    }

    @PostMapping("/finAccDetDataLine")
    @ApiOperation("数据映射查询")
    public ApiResult<List<FinAccEngDetDataLineVO>> queryFinAccDetDataLine(@RequestBody FinAccountEngineDetailsParam param) {
        return ApiResult.ok(finAccountEngineService.queryFinAccDetDataLine(param));
    }

    @PostMapping("/accountEngineDetails")
    @ApiOperation("会计引擎详情查询")
    public ApiResult<FinAccountEngineDetailsVO> queryAccountEngineDetails(@RequestBody FinAccountEngineDetailsParam param) {
        return ApiResult.ok(finAccountEngineService.queryAccountEngineDetails(param));
    }


    @PostMapping("enableOrDisable")
    @ApiOperation("启用/禁用")
    public ApiResult<Void> enableOrDisable(@RequestBody FinAccountEngineParam finAccountEngineParam) {
        finAccountEngineService.enableOrDisable(finAccountEngineParam);
        return ApiResult.ok();
    }

    @PostMapping("generateJournal")
    @ApiOperation("生成凭证")
    public ApiResult<Void> generateJournal(@RequestBody FinAccountEngineParam finAccountEngineParam) {
        finAccountEngineService.generateJournal(finAccountEngineParam);
        return ApiResult.ok();
    }
}
