package com.elitesland.fin.application.web.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.accountingengine.InvSobAccountPeriodParam;
import com.elitesland.fin.application.facade.vo.accountingengine.InvSobAccountPeriodVO;
import com.elitesland.fin.application.service.accountingengine.InvSobAccountPeriodService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author gyj
 * @date 2023/10/10
 */
@RestController
@RequestMapping("inv/account/period/control")
@RequiredArgsConstructor
@Api(value = "库存会计期间控制", tags = {"库存会计期间控制"})
public class InvSobAccountPeriodController {

    private final InvSobAccountPeriodService InvSobAccountPeriodService;

    @PostMapping("/generate")
    @ApiOperation("生成")
    public ApiResult<Void> generate(@RequestBody InvSobAccountPeriodParam InvSobAccountPeriodParam) {
        InvSobAccountPeriodService.generate(InvSobAccountPeriodParam);
        return ApiResult.ok();
    }

    @PostMapping("/page")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<InvSobAccountPeriodVO>> page(@RequestBody InvSobAccountPeriodParam InvSobAccountPeriodParam) {
        return ApiResult.ok(InvSobAccountPeriodService.page(InvSobAccountPeriodParam));
    }

    @PostMapping("/openOrClose")
    @ApiOperation("打开/关闭")
    public ApiResult<Void> openOrClose(@RequestBody InvSobAccountPeriodParam InvSobAccountPeriodParam) {
        InvSobAccountPeriodService.openOrClose(InvSobAccountPeriodParam);
        return ApiResult.ok();
    }

}
