package com.elitesland.fin.application.web.accountreport;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.account.AccountSnapshotParam;
import com.elitesland.fin.application.facade.param.accountreport.AccountReportPageParam;
import com.elitesland.fin.application.facade.vo.account.AccountBankInfoVo;
import com.elitesland.fin.application.facade.vo.account.AccountSnapshotVo;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.facade.vo.accountreport.AccountReportVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.accountreport.AccountReportService;
import com.elitesland.fin.common.UdcEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.web.account
 * @date 2023/2/15 18:23
 */
@RestController
@RequestMapping("/account/report")
@RequiredArgsConstructor
@Api(value = "账户报表", tags = {"账户报表"})
public class AccountController {

    private final AccountReportService accountReportService;

    @PostMapping("page")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<AccountReportVO>> page(@RequestBody AccountReportPageParam accountReportPageParam) {
        PagingVO<AccountReportVO> res = accountReportService.page(accountReportPageParam);
        return ApiResult.ok(res);
    }
}
