package com.elitesland.fin.config;

//import com.elitesland.order.service.SalSoReturnRpcService;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountAutoRepaymentService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.limitadjustorder.LimitAdjustOrderService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;


/**
 * 定时
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class JobHandler {

    private final LimitAdjustOrderService limitAdjustOrderService;

    private final InvoiceAwaitService invoiceAwaitService;

    private final CreditAccountService creditAccountService;

    private final AccountService accountService;

    private final CreditAccountAutoRepaymentService creditAccountAutoRepaymentService;

    @XxlJob(JobConstant.EXPIRE_LIMIT_ADJUST_ORDER)
    public ReturnT<String> expireLimitAdjustOrder(String param) {
        try {
            limitAdjustOrderService.expireLimitAdjustOrder();
        }catch (Exception e){
            XxlJobLogger.log("执行结果:============================"+ e.getMessage());
            return  ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    /**
     * 调整单定时生成流水
     * @param param
     * @return
     */
    @XxlJob(JobConstant.ACTIVE_LIMIT_ADJUST_ORDER)
    public ReturnT<String> activeLimitAdjustOrder(String param) {
        try {
            log.info("登录人信息：{}", SecurityContextUtil.currentUser());
            limitAdjustOrderService.activeLimitAdjustOrder();
        }catch (Exception e){
            XxlJobLogger.log("执行结果:============================"+ e.getMessage());
            return  ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }



    /**
     * 定时生成待开申请发票列表
     * @param param
     * @return
     */
    @XxlJob(JobConstant.INVOICE_AWAIT_ORDER)
    public ReturnT<String> invoiceAwaitOrder(String param) {
        try {
            invoiceAwaitService.invoiceAwaitOrder(param);
        } catch (Exception e) {
            XxlJobLogger.log("执行结果:============================" + e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(JobConstant.CREDIT_ACCOUNT_SNAPSHOT)
    public ReturnT<String> creditAccountSnapshot(String param) {
        XxlJobLogger.log("creditAccountSnapshot 参数:{}",param);
        try {
            creditAccountService.creditAccountSnapshot(param);
        } catch (Exception e) {
            XxlJobLogger.log("执行结果:============================" + e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(JobConstant.ACCOUNT_SNAPSHOT)
    public ReturnT<String> accountSnapshot(String param) {
        XxlJobLogger.log("accountSnapshot 参数:{}",param);
        try {
            accountService.accountSnapshot(param);
        } catch (Exception e) {
            XxlJobLogger.log("执行结果:============================" + e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    /**
     * 信用账户自动还款定时任务
     * @param param
     * @return
     */
    @XxlJob(JobConstant.CREDIT_ACCOUNT_AUTO_REPAYMENT)
    public ReturnT<String> creditAccountAutoRepayment(String param) {
        XxlJobLogger.log("信用账户自动还款定时任务 参数:{}",param);
        try {
            creditAccountAutoRepaymentService.creditAccountAutoRepayment(param);
        } catch (Exception e) {
            XxlJobLogger.log("信用账户自动还款定时任务执行结果:============================" + e.getMessage());
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

}
