package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_acc_eng_det_data")
@org.hibernate.annotations.Table(appliesTo = "fin_acc_eng_det_data", comment = "会计引擎数据行详情")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinAccEngDetDataDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;

    @Column(name = "serial_num", columnDefinition = "int(6) comment '序列号'")
    private Integer serialNum;

    @Column(name = "name", columnDefinition = "varchar(256) comment '行名称'")
    private String name;

    @Column(name = "sob_code", columnDefinition = "varchar(20) comment '账套编码'")
    private String sobCode;

    @Column(name = "sob_name", columnDefinition = "varchar(20) comment '账套名称'")
    private String sobName;

    @Column(name = "description", columnDefinition = "varchar(256) comment '行说明'")
    private String description;

    @Column(name = "debit_credit", columnDefinition = "varchar(8) comment '借贷方 D/C'")
    private String debitCredit;

    @Column(name = "combine_flag", columnDefinition = "tinyint(1) comment '是否合并'")
    private Boolean combineFlag;
    
}
