package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_sob_account_period")
@org.hibernate.annotations.Table(appliesTo = "fin_sob_account_period", comment = "会计期间控制")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinSobAccountPeriodDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "sob_code", columnDefinition = "varchar(20) comment '账套编码'")
    private String sobCode;

    @Column(name = "sob_name", columnDefinition = "varchar(32) comment '账套名称'")
    private String sobName;

    @Column(name = "account_period_code", columnDefinition = "varchar(20) comment '会计期间编码'")
    private String accountPeriodCode;

    @Column(name = "account_period_name", columnDefinition = "varchar(32) comment '会计期间名称'")
    private String accountPeriodName;

    @Column(name = "ou_code", columnDefinition = "varchar(20) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '公司名称'")
    private String ouName;

    @Column(name = "period_style",columnDefinition = "varchar(20)  comment '期间格式'")
    private String periodStyle;

    @Column(name = "status", columnDefinition = "varchar(32) comment '状态'")
    private String status;

    @Column(name = "active_start_time", columnDefinition = "datetime(6) comment '起始日期'")
    private LocalDateTime activeStartTime;

    @Column(name = "active_end_time", columnDefinition = "datetime(6) comment '结束日期'")
    private LocalDateTime activeEndTime;
}
