package com.elitesland.fin.domain.entity.base;

import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.MappedSuperclass;
import java.time.LocalDateTime;

/**
 * @author yangzhibin
 * @date 2023/4/13
 */
@Data
@MappedSuperclass
public class BaseWorkflowModel extends BaseModel {

    /**
     * 实例相关
     */
    @ApiModelProperty("工作流-流程实例ID")
    @Column(name = "workflow_proc_inst_id", columnDefinition = "varchar(40) comment '工作流-流程实例ID'")
    private String workflowProcInstId;

    @ApiModelProperty("工作流-流程实例状态")
    @Column(name = "workflow_proc_inst_status", columnDefinition = "varchar(40) comment '工作流-流程实例状态'")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus workflowProcInstStatus;

    /**
     * 时间相关
     */
    @ApiModelProperty(value = "工作流-提交时间")
    @Column(name = "workflow_submit_time", columnDefinition = "dateTime comment '工作流-提交时间'")
    private LocalDateTime workflowSubmitTime;

    @ApiModelProperty(value = "工作流-审批通过时间")
    @Column(name = "workflow_end_time", columnDefinition = "dateTime comment '工作流-审批通过时间'")
    private LocalDateTime workflowEndTime;

    /**
     * 当前节点节点
     */
    @ApiModelProperty(value = "工作流-当前审批节点KEY")
    @Column(name = "workflow_current_node_key", columnDefinition = "varchar(255) comment '工作流-当前审批节点KEY'")
    private String workflowCurrentNodeKey;

    @ApiModelProperty(value = "工作流-当前审批节点名称")
    @Column(name = "workflow_current_node_name", columnDefinition = "varchar(255) comment '工作流-当前审批节点名称'")
    private String workflowCurrentNodeName;

    @ApiModelProperty(value = "工作流-当前节点审批人用户ID（多个使用逗号分隔）")
    @Column(name = "workflow_current_handler_userids", columnDefinition = "text comment '工作流-当前节点审批人用户ID（多个使用逗号分隔）'")
    private String workflowCurrentUserIds;

    /**
     * 驳回相关
     */
    @ApiModelProperty(value = "工作流-审批驳回原因")
    @Column(name = "workflow_rejected_message", columnDefinition = "varchar(255) comment '工作流-审批驳回原因'")
    private String workflowRejectedMessage;

}
