package com.elitesland.fin.domain.entity.payorder;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author zhiyu.he
 * @date 2022/3/16 9:09
 */
@Entity
@Table(name="pay_order_dtl")
@org.hibernate.annotations.Table(appliesTo = "pay_order_dtl", comment = "付款单明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class PayOrderDtlDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -1683628069625567976L;
    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '总单ID'")
    private Long masId;

    @Column(name = "pay_type", columnDefinition = "varchar(32) comment '付款方式'")
    private String payType;

    @Column(name = "pay_bank", columnDefinition = "varchar(32) comment '我方开户行'")
    private String payBank;

    @Column(name = "pay_account", columnDefinition = "varchar(32) comment '我方银行账户'")
    private String payAccount;

    @Column(name = "rec_bank", columnDefinition = "varchar(32) comment '收款银行名称'")
    private String recBank;

    @Column(name = "rec_account", columnDefinition = "varchar(32) comment '收款银行账户'")
    private String recAccount;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "source_line", columnDefinition = "int(10) comment '来源行号'")
    private Integer sourceLine;

    @Column(name = "source_id", columnDefinition = "bigint(20) comment '来源单号ID'")
    private Long sourceId;

    @Column(name = "source_line_id", columnDefinition = "bigint(20) comment '来源行号ID'")
    private Long sourceLineId;

    @Column(name = "real_pay_amt", columnDefinition = "decimal(18,8) comment '实际支付金额'")
    private BigDecimal realPayAmt;

    @Column(name = "real_pay_cur_amt", columnDefinition = "decimal(18,8) comment '实际支付金额(本位币)'")
    private BigDecimal realPayCurAmt;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "expenses_type", columnDefinition = "varchar(32) comment '费用类型'")
    private String expensesType;

    @Column(name = "bu_id", columnDefinition = "bigint(20) comment '费用部门ID'")
    private Long buId;

    @Column(name = "bu_name", columnDefinition = "varchar(32) comment '费用部门'")
    private String buName;

    @Column(name = "bu_code", columnDefinition = "varchar(32) comment '费用部门编码'")
    private String buCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PayOrderDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PayOrderDtlDO entity = (PayOrderDtlDO) o;
        return getId().equals(entity.getId());
    }
    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
