package com.elitesland.fin.domain.service.artype;

import com.elitesland.fin.application.convert.aptype.ApTypeOuConvert;
import com.elitesland.fin.application.convert.artype.ArTypeOuConvert;
import com.elitesland.fin.application.facade.vo.artype.ArTypeOuVO;
import com.elitesland.fin.domain.entity.aptype.ApTypeOuDO;
import com.elitesland.fin.domain.entity.artype.ArTypeOu;
import com.elitesland.fin.domain.entity.artype.ArTypeOuDO;
import com.elitesland.fin.domain.param.artype.ArTypeOuPageParam;
import com.elitesland.fin.infr.dto.artype.ArTypeOuDTO;
import com.elitesland.fin.infr.repo.artype.ArTypeOuRepo;
import com.elitesland.fin.infr.repo.artype.ArTypeOuRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.artype
 * @date 2022/4/11 15:59
 */
@Service
@RequiredArgsConstructor
public class ArTypeOuDomainServiceImpl implements ArTypeOuDomainService {

    private final ArTypeOuRepo arTypeOuRepo;
    private final ArTypeOuRepoProc arTypeOuRepoProc;

    @Override
    public List<ArTypeOuDTO> queryByArTypeId(Long id) {
        List<ArTypeOuDTO> res = arTypeOuRepoProc.queryByArTypeId(id);
        return res;
    }

    @Override
    public PagingVO<ArTypeOuDTO> page(ArTypeOuPageParam arTypeOuPageParam) {
        PagingVO<ArTypeOuDTO> res = arTypeOuRepoProc.page(arTypeOuPageParam);
        return res;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long addOu(ArTypeOu arTypeOu) {

        ArTypeOuDO arTypeOuDO = ArTypeOuConvert.INSTANCE.convert(arTypeOu);
        // 验证apTypeId 和 ouid是否存在，
        Boolean isExist = arTypeOuRepoProc.existByApTypeIdOuId(arTypeOuDO);
        if (!isExist) {
            ArTypeOuDO save = arTypeOuRepo.save(arTypeOuDO);
            return save.getId();
        }
        return arTypeOuDO.getArTypeId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long cancelOu(List<Long> ids) {
        Long res = arTypeOuRepoProc.cancelOu(ids);
        return res;
    }

}
