package com.elitesland.fin.infr.repo.rectype;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.fin.domain.entity.rectype.QRecTypeDO;
import com.elitesland.fin.domain.param.rectype.RecTypePageParam;
import com.elitesland.fin.infr.dto.rectype.RecTypeDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/11 13:14
 */
@Component
@RequiredArgsConstructor
public class RecTypeRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QRecTypeDO qRecTypeDO = QRecTypeDO.recTypeDO;

    public RecTypeDTO queryById(Long id) {
        return select(RecTypeDTO.class)
                .where(qRecTypeDO.id.eq(id))
                .fetchOne();
    }

    public RecTypeDTO defaultValue() {
        return select(RecTypeDTO.class)
                .where(qRecTypeDO.defaultFlag.isTrue())
                .where(qRecTypeDO.enableFlag.isTrue())
                .fetchOne();
    }

    public Boolean queryIsAutoAudit(Long id){
        return jpaQueryFactory.select(qRecTypeDO.autoAudit)
                .from(qRecTypeDO)
                .where(qRecTypeDO.id.eq(id))
                .fetchOne();
    }
    public Boolean isFirst() {
        return jpaQueryFactory.select(qRecTypeDO.id)
                .from(qRecTypeDO)
                .where(qRecTypeDO.deleteFlag.eq(0))
                .fetchCount() > 0;
    }
    public List<RecTypeDTO> findAll() {
        return select(RecTypeDTO.class)
                .where(qRecTypeDO.enableFlag.isTrue())
                .fetch();
    }
    public Boolean existRecCode(String payCode) {
        return jpaQueryFactory.select(qRecTypeDO.recTypeCode)
                .from(qRecTypeDO)
                .where(qRecTypeDO.recTypeCode.eq(payCode))
                .fetchCount() > 0;
    }
    public void updateDefault() {
        jpaQueryFactory.update(qRecTypeDO)
                .set(qRecTypeDO.defaultFlag, false)
                .where(qRecTypeDO.defaultFlag.isTrue())
                .execute();
    }

    public Long updateDefaultById(Long id, Boolean isDefault) {
        return jpaQueryFactory.update(qRecTypeDO)
                .set(qRecTypeDO.defaultFlag, isDefault)
                .where(qRecTypeDO.id.eq(id))
                .execute();
    }

    public void delete(List<Long> ids){
        jpaQueryFactory.delete(qRecTypeDO)
                .where(qRecTypeDO.id.in(ids))
                .execute();
    }
    public void updateEnable(List<Long> ids, Boolean trueOrFalse) {
        jpaQueryFactory.update(qRecTypeDO)
                .set(qRecTypeDO.enableFlag, trueOrFalse)
                .where(qRecTypeDO.id.in(ids))
                .execute();
    }

    public List<RecTypeDTO> findByIds(Collection<Long> ids) {
        return select(RecTypeDTO.class)
                .where(qRecTypeDO.id.in(ids))
                .where(qRecTypeDO.deleteFlag.eq(0))
                .fetch();
    }

    public Boolean existRecName(String payName) {
        return jpaQueryFactory.select(qRecTypeDO.recTypeName)
                .from(qRecTypeDO)
                .where(qRecTypeDO.recTypeName.eq(payName))
                .fetchCount() > 0;
    }

    public PagingVO<RecTypeDTO> page(RecTypePageParam param, List<Long> ids) {
        // 条件拼接
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(param.getRecTypeCode())) {
            predicates.add(qRecTypeDO.recTypeCode.like('%' + param.getRecTypeCode() + '%'));
        }
        if (StringUtils.isNotBlank(param.getRecTypeName())) {
            predicates.add(qRecTypeDO.recTypeName.like('%' + param.getRecTypeName() + '%'));
        }
        if (!CollUtil.isEmpty(ids)) {
            predicates.add(qRecTypeDO.id.in(ids));
        }
        predicates.add(qRecTypeDO.deleteFlag.eq(0));
        JPAQuery<RecTypeDTO> query = select(RecTypeDTO.class).where(ExpressionUtils.allOf(predicates));
        param.setPaging(query);
        param.fillOrders(query, qRecTypeDO);
        return PagingVO.<RecTypeDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qRecTypeDO.id,
                qRecTypeDO.recTypeCode,
                qRecTypeDO.recTypeName,
                qRecTypeDO.enableFlag,
                qRecTypeDO.defaultFlag,
                qRecTypeDO.autoAudit
                )
        ).from(qRecTypeDO);
    }

}
