package com.elitesland.fin.provider.arorder;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.Application;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.facade.vo.arorder.ArOrderVO;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.application.service.arorder.ArOrderServiceImpl;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.dto.arorder.ArOrderRpcDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.param.arorder.ArOrderPageRpcParam;
import com.elitesland.fin.param.arorder.ArOrderRpcParam;
import com.elitesland.fin.service.aporder.ApOrderRpcService;
import com.elitesland.fin.service.arorder.ArOrderRpcService;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.arorder
 * 应收单
 * @date 2022/5/18 15:53
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + ArOrderRpcService.PATH)
public class ArOrderRpcServiceImpl implements ArOrderRpcService {

    private final ArOrderDomainService arOrderDomainService;

    @Override
    public Long save(ArOrderRpcParam arOrderRpcParam) {
        if (CharSequenceUtil.isBlank(arOrderRpcParam.getCreateMode())) {
            throw new BusinessException("createMode不能为空");
        }
        ArOrder arOrder = ArOrderConvert.INSTANCE.convertRpc(arOrderRpcParam);
        Long resId = arOrderDomainService.save(arOrder);
        return resId;
    }

    @Override
    public ApiResult<PagingVO<ArOrderRpcDTO>> page(ArOrderPageRpcParam arOrderPageRpcParam) {
        PagingVO<ArOrderDTO> arOrderVOPagingVO = arOrderDomainService
                .page(ArOrderConvert.INSTANCE.arOrderPageRpcParam2ArOrderPageParam(arOrderPageRpcParam));
        return ApiResult.ok(ArOrderConvert.INSTANCE.arOrderDTOPagingVO2ArOrderRpcDTOPagingVO(arOrderVOPagingVO));

    }
}
