package com.elitesland.fin.provider.creditaccountflow;


import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.creditaccountflow.CreditAccountFlowConvert;
import com.elitesland.fin.application.convert.flow.AccountFlowConvert;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.dto.account.AccountIocDTO;
import com.elitesland.fin.application.facade.param.account.AccountIocParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.param.account.AccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowQueryParam;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigPageVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.dto.flow.AccountFlowRpcDTO;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.param.creditaccountflow.CreditAccountFlowRpcParam;
import com.elitesland.fin.param.flow.AccountFlowRpcParam;
import com.elitesland.fin.rocketmq.channel.FinSalMqProcessor;
import com.elitesland.fin.service.creditaccountflow.CreditAccountFlowRpcService;
import com.elitesland.fin.service.flow.AccountFlowRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.task.TaskExecutor;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + AccountFlowRpcService.PATH)
@Slf4j
public class CreditAccountFlowRpcServiceImpl implements CreditAccountFlowRpcService {

    public final CreditAccountFlowService creditAccountFlowService;

    @Override
    public ApiResult<Boolean> generateCreditAccountFlow(CreditAccountFlowRpcParam creditAccountFlowRpcParam) {
        CreditAccountFlowParam creditAccountFlowParam = CreditAccountFlowConvert.INSTANCE
                .creditAccountFlowRpcParam2CreditAccountFlowParam(creditAccountFlowRpcParam);
        creditAccountFlowService.generateCreditAccountFlow(creditAccountFlowParam);
        return ApiResult.ok();
    }
}
