package com.elitesland.fin.provider.recorder;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.Application;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.service.recorder.RecOrderRpcTwoService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.recorder.RecOrder;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcPageRespVo;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.dto.recorder.RecOrderRpcDTO;
import com.elitesland.fin.param.recorder.RecOrderRpcPageParam;
import com.elitesland.fin.param.recorder.RecOrderRpcParam;
import com.elitesland.fin.service.recorder.RecOrderRpcService;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.recorder
 * @date 2022/5/19 10:14
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + RecOrderRpcService.PATH)
public class RecOrderRpcServiceImpl implements RecOrderRpcService {

    public final RecOrderDomainService recOrderDomainService;
    public final RecOrderRpcTwoService recOrderRpcTwoService;

    @Override
    public Long save(RecOrderRpcParam recOrderRpcParam) {
        if (CharSequenceUtil.isBlank(recOrderRpcParam.getCreateMode())) {
            throw new BusinessException("来源单据 createMode不能为空");
        }
        RecOrder recOrder = RecOrderConvert.INSTANCE.convertRpc(recOrderRpcParam);
        recOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        Long resId = recOrderDomainService.save(recOrder);
        return resId;
    }

    @Override
    public ApiResult<PagingVO<RecOrderRpcDTO>> page(RecOrderRpcPageParam recOrderRpcPageParam) {

        PagingVO<RecOrderRpcPageRespVo> recOrderRpcPageRespVoPagingVO = recOrderRpcTwoService
                .queryRecOrderRpcPageList(RecOrderConvert.INSTANCE.recOrderRpcPageParam2RecOrderRpcTwoParam(recOrderRpcPageParam));

        return ApiResult.ok(RecOrderConvert.INSTANCE.recOrderRpcPageRespVoPagingVO2RecOrderRpcDTOPagingVO(recOrderRpcPageRespVoPagingVO));


    }
}
