package com.elitesland.fin.repo.account;

import com.elitesland.fin.entity.account.AccountStorageDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author sunxw
 * @description
 * @Date 2023/5/18
 */
@Repository
public interface AccountStorageRepo extends JpaRepository<AccountStorageDO,Long>, QuerydslPredicateExecutor<AccountStorageDO> {

    /**
     * 更新单据状态
     * @param payOrderId
     * @param receiptStatus
     */
    @Modifying
    @Query(value = "update account_storage set receipt_status = :receiptStatus where pay_order_id = :payOrderId",nativeQuery = true)
    void updateReceiptStatus(@Param("payOrderId") String payOrderId, @Param("receiptStatus") String receiptStatus);

    /**
     * 根据支付流水号查询主键
     * @param payOrderId
     */
    @Query(value = "select id from account_storage where pay_order_id = :payOrderId",nativeQuery = true)
    Long getIdByOrderId(@Param("payOrderId") String payOrderId);

    /**
     * 根据支付流水号查询单据状态
     * @param payOrderId
     */
    @Query(value = "select receipt_status from account_storage where pay_order_id = :payOrderId",nativeQuery = true)
    String getReceiptStatusByOrderId(@Param("payOrderId") String payOrderId);

    /**
     * 根据支付流水号查询开户主体
     * @param id
     * @return
     */
    @Query(value = "select remitter from account_storage where id= :id",nativeQuery = true)
    String getRemitterIdByKey(@Param("id") Long id);

    /**
     * 更新oriMsg
     * @param payOrderId
     * @param oriMsg
     */
    @Modifying
    @Query(value = "update account_storage set ori_msg = :oriMsg,pay_message = :payMessage where pay_order_id = :payOrderId",nativeQuery = true)
    void updateMsg(@Param("payOrderId") String payOrderId, @Param("oriMsg") String oriMsg,@Param("payMessage") String payMessage);

    List<AccountStorageDO> findByPayOrderId(String PayOrderId);
}
