package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinEventTableConditionConvert;
import com.elitesland.fin.application.convert.accountingengine.FinEventTableLineConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.*;
import com.elitesland.fin.application.facade.param.accountingengine.FinEventTableParam;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinEventTableDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinSetOfBookDO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinEventTableRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final FinEventTableRepo finEventTableRepo;
    private final FinEventTableConditionRepo finEventTableConditionRepo;
    private final FinEventTableLineRepo finEventTableLineRepo;

    private final QFinEventTableDO qFinEventTableDO = QFinEventTableDO.finEventTableDO;

    public PagingVO<FinEventTableDTO> page(FinEventTableParam finEventTableParam) {
        Predicate where = where(finEventTableParam);
        JPAQuery<FinEventTableDTO> query = select(FinEventTableDTO.class).where(ExpressionUtils.allOf(where));
        finEventTableParam.setPaging(query);
        finEventTableParam.fillOrders(query, qFinEventTableDO);

        List<FinEventTableDTO> finSetOfBookDTOList = query.fetch();

        List<Long> ids = finSetOfBookDTOList.stream().map(FinEventTableDTO::getId).collect(Collectors.toList());

        List<FinEventTableLineDTO> finEventTableLineDTOList = FinEventTableLineConvert.INSTANCE.DOToDTO(finEventTableLineRepo.findAllByMasIdIn(ids));
        List<FinEventTableConditionDTO> finEventTableConditionDTOList = FinEventTableConditionConvert.INSTANCE.DOToDTO(finEventTableConditionRepo.findAllByMasIdIn(ids));

        for (FinEventTableDTO finSetOfBookDTO : finSetOfBookDTOList) {

            finSetOfBookDTO.setFinEventTableLineDetailList(finEventTableLineDTOList.stream()
                    .filter(finSetOfBookLineDTO -> finSetOfBookDTO.getId().equals(finSetOfBookLineDTO.getMasId()))
                    .collect(Collectors.toList()));

            finSetOfBookDTO.setFinEventTableConditionDetailList(finEventTableConditionDTOList.stream()
                    .filter(finSetOfBookOuDTO -> finSetOfBookDTO.getId().equals(finSetOfBookOuDTO.getMasId()))
                    .collect(Collectors.toList()));
        }

        return PagingVO.<FinEventTableDTO>builder()
                .total(finSetOfBookDTOList.size())
                .records(finSetOfBookDTOList)
                .build();
    }

    private Predicate where(FinEventTableParam finEventTableParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(finEventTableParam.getId() != null, qFinEventTableDO.id, finEventTableParam.getId())
                .andLike(StringUtils.isNotEmpty(finEventTableParam.getEventTable()), qFinEventTableDO.eventTable, StringUtil.buildLikeString(finEventTableParam.getEventTable()))
                .andEq(finEventTableParam.getStatus() != null, qFinEventTableDO.status, finEventTableParam.getStatus())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qFinEventTableDO.id,
                qFinEventTableDO.eventTable,
                qFinEventTableDO.host,
                qFinEventTableDO.port,
                qFinEventTableDO.user,
                qFinEventTableDO.password,
                qFinEventTableDO.database,
                qFinEventTableDO.masTable,
                qFinEventTableDO.table,
                qFinEventTableDO.masTableColumn,
                qFinEventTableDO.tableColumn,
                qFinEventTableDO.status,

                qFinEventTableDO.createTime,
                qFinEventTableDO.creator,
                qFinEventTableDO.modifyTime,
                qFinEventTableDO.updater
        )).from(qFinEventTableDO);
    }


    public FinEventTableDO findByEventTable(String eventTable) {

        List<FinEventTableDO> finEventTableDOList = finEventTableRepo.findAllByEventTable(eventTable);

        if (CollectionUtils.isNotEmpty(finEventTableDOList)) {
            Assert.equals(finEventTableDOList.size(), 1, "查询到多条事件表单");
            return finEventTableDOList.get(0);
        }
        return null;
    }


}
