package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFastCodeLineConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinFastCodeDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinFastCodeLineDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinFastCodeParam;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeLineDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinFastCodeDO;
import com.elitesland.fin.utils.StringUtil;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Component
@RequiredArgsConstructor
public class FinFastCodeLineRepoProc {


    private final FinFastCodeLineRepo finFastCodeLineRepo;



    public List<FinFastCodeLineDO> findByMasIdIn(List<Long> ids) {

        if(CollectionUtils.isEmpty(ids)){
            return Lists.newArrayList();
        }

        List<FinFastCodeLineDO> finFastCodeLineDOList = finFastCodeLineRepo.findAllByMasIdIn(ids);
        Assert.notEmpty(finFastCodeLineDOList,"查不到快码明细");

        return finFastCodeLineDOList;
    }


}
